/*
 * Decompiled with CFR 0.152.
 */
package jwebform.processors;

import java.util.HashSet;
import java.util.Map;
import jwebform.element.structure.ElementContainer;
import jwebform.element.structure.ElementResult;
import jwebform.processors.ElementResults;
import jwebform.processors.PostProcessor;

public class CheckDoubleElementsPostProcessor
implements PostProcessor {
    @Override
    public ElementResults postProcess(ElementResults results) {
        HashSet<String> availElements = new HashSet<String>();
        for (Map.Entry<ElementContainer, ElementResult> entry : results) {
            if (entry.getValue().getStaticElementInfo().getName() == "" || availElements.add(entry.getValue().getStaticElementInfo().getName())) continue;
            throw new DoubleTakenNameException(entry.getValue().getStaticElementInfo().getName());
        }
        return results;
    }

    public class DoubleTakenNameException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DoubleTakenNameException(String name) {
            super(String.format("The name %s was taken more than once for this form. Make sure, that you use eache name of each element only once!", name));
        }
    }
}

