/*
 * Decompiled with CFR 0.152.
 */
package jwebform.env;

import jwebform.env.Request;
import jwebform.env.SessionGet;
import jwebform.env.SessionSet;

public class Env {
    private final Request request;
    private final SessionGet sessionGet;
    private final SessionSet sessionSet;
    static final SessionGet EMPTY_SESSION_GET = t -> "";
    static final SessionSet EMPTY_SESSION_SET = (k, v) -> {};
    private static final String SUBMIT_KEY = "WF_SUBMITTED";
    public static final String SUBMIT_VALUE_PREFIX = "WF-";

    protected Env(Request request, SessionGet sessionGet, SessionSet sessionSet) {
        this.request = request;
        this.sessionGet = sessionGet;
        this.sessionSet = sessionSet;
    }

    public Request getRequest() {
        return this.request;
    }

    public SessionGet getSessionGet() {
        return this.sessionGet;
    }

    public SessionSet getSessionSet() {
        return this.sessionSet;
    }

    public void ensureSessionAvail() {
        if (this.getSessionGet() == EMPTY_SESSION_GET || this.getSessionSet() == EMPTY_SESSION_SET) {
            throw new SessionMissingException();
        }
    }

    public EnvWithSubmitInfo getEnvWithSumitInfo(String formId) {
        return new EnvWithSubmitInfo(formId, this);
    }

    public Env cloneWithMaxLenInput(int maxLen) {
        return new Env(i -> this.cutString(this.request.getParameter(i), maxLen), this.sessionGet, this.sessionSet);
    }

    public Env cloneWithNullCheck() {
        return new Env(i -> this.nullSave(this.request.getParameter(i)), this.sessionGet, this.sessionSet);
    }

    public Env cloneWithTrim() {
        return new Env(i -> this.request.getParameter(i).trim(), this.sessionGet, this.sessionSet);
    }

    private String nullSave(String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    private String cutString(String s, int len) {
        if (s == null) {
            return null;
        }
        if (s.length() < len) {
            return s;
        }
        return s.substring(0, len);
    }

    public class EnvWithSubmitInfo {
        private final Env env;
        private final boolean submitted;

        public EnvWithSubmitInfo(String formId, Env env) {
            this.env = env;
            this.submitted = (Env.SUBMIT_VALUE_PREFIX + formId).equals(env.getRequest().getParameter(Env.SUBMIT_KEY));
        }

        public Env getEnv() {
            return this.env;
        }

        public boolean isSubmitted() {
            return this.submitted;
        }
    }

    public class SessionMissingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SessionMissingException() {
            super("Session data missing in Env. \nPlease provide sessionGet() and sessionSet() in Env!\n\n...This is needed for XSRF-Protection.\n\nExample: \nnew Env(requestParamName -> request.getParameter(requestParamName),\t// Request\nsessionParamName -> request.getSession().getAttribute(sessionParamName), // SessionGet\n(sessionParamName, value) -> request.getSession().setAttribute(sessionParamName, value) // SessionSet\n);");
        }
    }
}

