/*
 * Decompiled with CFR 0.152.
 */
package jwebform.element.structure;

import java.util.function.Predicate;
import jwebform.element.structure.ElementResult;
import jwebform.element.structure.HTMLProducer;
import jwebform.element.structure.StaticElementInfo;
import jwebform.env.Env;
import jwebform.validation.ValidationResult;
import jwebform.validation.Validator;

public class OneValueElementProcessor {
    public final String name;
    public final String initialValue;
    public final Predicate<String> alwaysFine = t -> true;

    public OneValueElementProcessor(String name, String initialValue) {
        this.name = name;
        this.initialValue = initialValue;
    }

    public ElementResult calculateElementResultWithInputCheck(Env.EnvWithSubmitInfo env, HTMLProducer htmlProducer, Predicate<String> validateInput) {
        return this.calculateElementResultWithInputCheck(env, htmlProducer, validateInput, 1);
    }

    public ElementResult calculateElementResultWithInputCheck(Env.EnvWithSubmitInfo env, HTMLProducer htmlProducer, Predicate<String> validateInput, int tabIndexIncr) {
        String requestVal = env.getEnv().getRequest().getParameter(this.name);
        String value = "";
        String input = this.fetchValue(env, requestVal, this.initialValue);
        if (validateInput.test(input)) {
            value = input;
        }
        return ElementResult.builder().withValue(value).withStaticElementInfo(new StaticElementInfo(this.name, htmlProducer, tabIndexIncr)).build();
    }

    public ElementResult calculateElementResult(Env.EnvWithSubmitInfo env, HTMLProducer htmlProducer) {
        return this.calculateElementResultWithInputCheck(env, htmlProducer, this.alwaysFine);
    }

    public ElementResult calculateElementResultNoTabIndexIncrement(Env.EnvWithSubmitInfo env, HTMLProducer htmlProducer) {
        return this.calculateElementResultWithInputCheck(env, htmlProducer, this.alwaysFine, 0);
    }

    public ValidationResult validate(Env.EnvWithSubmitInfo env, Validator validator, String value) {
        if (env.isSubmitted()) {
            return validator.validate(value);
        }
        return ValidationResult.undefined();
    }

    private String fetchValue(Env.EnvWithSubmitInfo env, String requestVal, String initialValue) {
        if (env.isSubmitted()) {
            return requestVal;
        }
        return initialValue;
    }
}

