/*
 * Decompiled with CFR 0.152.
 */
package jwebform.element.structure;

import jwebform.element.structure.StaticElementInfo;
import jwebform.processors.ElementResults;
import jwebform.validation.ValidationResult;

public final class ElementResult {
    private final ValidationResult validationResult;
    private final String value;
    private final Object valueObject;
    private final StaticElementInfo staticElementInfo;
    private final ElementResults childs;
    private static final String EMPTY_STRING = "";
    public static final String NO_NAME = "";
    public static final ElementResults NOCHILDS = new ElementResults();

    private ElementResult(Builder builder) {
        this.validationResult = builder.validationResult;
        this.value = builder.value;
        this.valueObject = builder.valueObject;
        this.staticElementInfo = builder.staticElementInfo;
        this.childs = builder.childs;
    }

    public ElementResult ofValidationResult(ValidationResult vr) {
        return ElementResult.builder().withChilds(this.childs).withStaticElementInfo(this.staticElementInfo).withValidationResult(vr).withValue(this.value).withValueObject(this.valueObject).build();
    }

    public ElementResult cloneWithChilds(ElementResults childs) {
        return ElementResult.builder().withChilds(childs).withStaticElementInfo(this.staticElementInfo).withValidationResult(this.validationResult).withValue(this.value).withValueObject(this.valueObject).build();
    }

    public ElementResult cloneWithNewValidationResult(ValidationResult newValidationResult) {
        return ElementResult.builder().withChilds(this.childs).withStaticElementInfo(this.staticElementInfo).withValidationResult(newValidationResult).withValue(this.value).withValueObject(this.valueObject).build();
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public String getValue() {
        return this.value;
    }

    public ElementResults getChilds() {
        return this.childs;
    }

    public StaticElementInfo getStaticElementInfo() {
        return this.staticElementInfo;
    }

    public Object getValueObject() {
        return this.valueObject;
    }

    public String toString() {
        return String.format("ElementResult: %s", this.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ValidationResult validationResult = ValidationResult.undefined();
        private String value = "";
        private Object valueObject = "";
        private StaticElementInfo staticElementInfo;
        private ElementResults childs = new ElementResults();

        private Builder() {
        }

        public Builder withValidationResult(ValidationResult validationResult) {
            this.validationResult = validationResult;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withValueObject(Object valueObject) {
            this.valueObject = valueObject;
            return this;
        }

        public Builder withStaticElementInfo(StaticElementInfo staticElementInfo) {
            this.staticElementInfo = staticElementInfo;
            return this;
        }

        public Builder withChilds(ElementResults childs) {
            this.childs = childs;
            return this;
        }

        public ElementResult build() {
            return new ElementResult(this);
        }
    }
}

