/*
 * Decompiled with CFR 0.152.
 */
package jwebform.element.structure;

import java.util.ArrayList;
import java.util.List;
import jwebform.element.SelectType;

public class CommonSelects {
    private static final String[] months = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};

    private CommonSelects() {
    }

    public static CommonSelects build() {
        return new CommonSelects();
    }

    public List<SelectType.SelectInputEntry> buildDays() {
        return this.buildMap(1, 31, "jformchecker.select.day");
    }

    public List<SelectType.SelectInputEntry> buildMonths() {
        ArrayList<SelectType.SelectInputEntry> monthsList = new ArrayList<SelectType.SelectInputEntry>();
        for (int i = 1; i <= 12; ++i) {
            monthsList.add(new SelectType.SelectInputEntry(Integer.toString(i), "jformchecker.select." + months[i - 1]));
        }
        return monthsList;
    }

    public List<SelectType.SelectInputEntry> getYears(int startYear, int endYear) {
        if (startYear < endYear) {
            int tmp = startYear;
            startYear = endYear;
            endYear = tmp;
        }
        return this.builReverseMap(startYear, endYear, "jformchecker.select.year");
    }

    public List<SelectType.SelectInputEntry> getGenderSelect() {
        ArrayList<SelectType.SelectInputEntry> genderSelect = new ArrayList<SelectType.SelectInputEntry>();
        this.addToList(genderSelect, "f", "jformchecker.select.female");
        this.addToList(genderSelect, "m", "jformchecker.select.male");
        return genderSelect;
    }

    private List<SelectType.SelectInputEntry> buildMap(int start, int end, String first) {
        ArrayList<SelectType.SelectInputEntry> dayMap = new ArrayList<SelectType.SelectInputEntry>();
        this.addToList(dayMap, "", first);
        for (int i = start; i <= end; ++i) {
            this.addToList(dayMap, Integer.toString(i), Integer.toString(i));
        }
        return dayMap;
    }

    private List<SelectType.SelectInputEntry> builReverseMap(int start, int end, String first) {
        ArrayList<SelectType.SelectInputEntry> entries = new ArrayList<SelectType.SelectInputEntry>();
        entries.add(new SelectType.SelectInputEntry("", first));
        for (int i = start; i >= end; --i) {
            entries.add(new SelectType.SelectInputEntry(Integer.toString(i), Integer.toString(i)));
        }
        return entries;
    }

    private void addToList(List<SelectType.SelectInputEntry> list, String key, String value) {
        list.add(new SelectType.SelectInputEntry(key, value));
    }
}

