/*
 * Decompiled with CFR 0.152.
 */
package jwebform.element.builder;

import java.time.LocalDate;
import java.util.List;
import jwebform.element.CheckBoxType;
import jwebform.element.HiddenType;
import jwebform.element.HtmlType;
import jwebform.element.LabelType;
import jwebform.element.NumberType;
import jwebform.element.PasswordType;
import jwebform.element.RadioType;
import jwebform.element.SelectDateType;
import jwebform.element.SelectType;
import jwebform.element.SimpleType;
import jwebform.element.SubmitType;
import jwebform.element.TextAreaType;
import jwebform.element.TextDateType;
import jwebform.element.TextType;
import jwebform.element.UploadType;
import jwebform.element.XSRFProtectionType;
import jwebform.element.builder.TypeBuilder;

public class Type {
    private Type() {
    }

    public static TypeBuilder text(String name, String initialValue) {
        return new TypeBuilder().withTypeSupplier(() -> new TextType(name, initialValue));
    }

    public static TypeBuilder text(String name) {
        return Type.text(name, "");
    }

    public static TypeBuilder simple() {
        return new TypeBuilder().withTypeSupplier(() -> new SimpleType());
    }

    public static TypeBuilder checkbox(String name, boolean initialValue) {
        return new TypeBuilder().withTypeSupplier(() -> new CheckBoxType(name, initialValue));
    }

    public static TypeBuilder checkbox(String name) {
        return Type.checkbox(name, false);
    }

    public static TypeBuilder hidden(String name, String initialValue) {
        return new TypeBuilder().withTypeSupplier(() -> new HiddenType(name, initialValue));
    }

    public static TypeBuilder html(String html) {
        return new TypeBuilder().withTypeSupplier(() -> new HtmlType(html));
    }

    public static TypeBuilder label(String label) {
        return new TypeBuilder().withTypeSupplier(() -> new LabelType(label));
    }

    public static TypeBuilder number(String name, int initialValue) {
        return new TypeBuilder().withTypeSupplier(() -> new NumberType(name, initialValue));
    }

    public static TypeBuilder number(String name) {
        return Type.number(name, 0);
    }

    public static TypeBuilder password(String name) {
        return new TypeBuilder().withTypeSupplier(() -> new PasswordType(name));
    }

    public static TypeBuilder radio(String name, String initialValue, String[] keys, String[] values) {
        return new TypeBuilder().withTypeSupplier(() -> new RadioType(name, initialValue, keys, values));
    }

    public static TypeBuilder submit(String name) {
        return new TypeBuilder().withTypeSupplier(() -> new SubmitType(name));
    }

    public static TypeBuilder submit() {
        return new TypeBuilder().withTypeSupplier(() -> new SubmitType("submit"));
    }

    public static TypeBuilder textArea(String name, String initialValue) {
        return new TypeBuilder().withTypeSupplier(() -> new TextAreaType(name, initialValue));
    }

    public static TypeBuilder textArea(String name) {
        return Type.textArea(name, "");
    }

    public static TypeBuilder upload(String name) {
        return new TypeBuilder().withTypeSupplier(() -> new UploadType(name));
    }

    public static TypeBuilder xsrfProtection() {
        return new TypeBuilder().withTypeSupplier(() -> new XSRFProtectionType());
    }

    public static TypeBuilder xsrfProtectionForTesting() {
        return new TypeBuilder().withTypeSupplier(() -> new XSRFProtectionType(true));
    }

    public static TypeBuilder select(String name, List<SelectType.SelectInputEntryGroup> groups, String initialValue) {
        return new TypeBuilder().withTypeSupplier(() -> new SelectType(name, groups, initialValue));
    }

    public static TypeBuilder select(String name, String initialValue, List<SelectType.SelectInputEntry> entries) {
        return new TypeBuilder().withTypeSupplier(() -> new SelectType(name, initialValue, entries));
    }

    public static TypeBuilder select(String name, String initialValue, String[] keys, String[] values) {
        return new TypeBuilder().withTypeSupplier(() -> new SelectType(name, initialValue, keys, values));
    }

    public static TypeBuilder selectDate(String name, LocalDate initialValue, int yearStart, int yearEnd) {
        return new TypeBuilder().withTypeSupplier(() -> new SelectDateType(name, initialValue, yearStart, yearEnd));
    }

    public static TypeBuilder textDate(String name, LocalDate initialValue) {
        return new TypeBuilder().withTypeSupplier(() -> new TextDateType(name, initialValue));
    }
}

