/*
 * Decompiled with CFR 0.152.
 */
package jwebform.element;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import jwebform.element.DateTypeHelper;
import jwebform.element.SelectType;
import jwebform.element.structure.CommonSelects;
import jwebform.element.structure.Decoration;
import jwebform.element.structure.ElementContainer;
import jwebform.element.structure.ElementResult;
import jwebform.element.structure.GroupType;
import jwebform.env.Env;
import jwebform.processors.ElementResults;
import jwebform.validation.FormValidator;
import jwebform.validation.Validator;
import jwebform.validation.criteria.Criteria;

public class SelectDateType
implements GroupType {
    private final ElementContainer day;
    private final ElementContainer month;
    private final ElementContainer year;
    private final DateTypeHelper helper;

    public SelectDateType(String name, LocalDate initialValue, int yearStart, int yearEnd) {
        Validator numberValidator = new Validator(Criteria.number());
        this.day = new SelectType(name + "_day", String.valueOf(initialValue.getDayOfMonth()), CommonSelects.build().buildDays()).of(numberValidator, new Decoration("Day"));
        this.month = new SelectType(name + "_month", String.valueOf(initialValue.getMonthValue()), CommonSelects.build().buildMonths()).of(numberValidator, new Decoration("Month"));
        this.year = new SelectType(name + "_year", String.valueOf(initialValue.getYear()), CommonSelects.build().getYears(yearStart, yearEnd)).of(numberValidator, new Decoration("Year"));
        this.helper = new DateTypeHelper(this.day, this.month, this.year, initialValue, name);
    }

    @Override
    public List<ElementContainer> getChilds() {
        return Arrays.asList(this.day, this.month, this.year);
    }

    @Override
    public ElementResult process(Env.EnvWithSubmitInfo env, ElementResults childs) {
        return this.helper.processDateVal(env, childs, "select date");
    }

    @Override
    public List<FormValidator> getValidators(ElementContainer source) {
        return this.helper.getValidators();
    }
}

