/*
 * Decompiled with CFR 0.152.
 */
package jwebform.element;

import java.util.ArrayList;
import java.util.List;
import jwebform.element.structure.ElementResult;
import jwebform.element.structure.OneValueElementProcessor;
import jwebform.element.structure.SingleType;
import jwebform.env.Env;

public class RadioType
implements SingleType {
    public final List<RadioInputEntry> entries;
    public final OneValueElementProcessor oneValueElement;

    public RadioType(String name, String initialValue, String[] keys, String[] values) {
        this.oneValueElement = new OneValueElementProcessor(name, initialValue);
        this.entries = this.generateEntriesFromKeyValues(keys, values);
    }

    @Override
    public ElementResult apply(Env.EnvWithSubmitInfo env) {
        return this.oneValueElement.calculateElementResultWithInputCheck(env, t -> "<!-- checkbox -->", this::ensureValueIsAllowed);
    }

    private boolean ensureValueIsAllowed(String fetchValue) {
        for (RadioInputEntry selectInputEntry : this.entries) {
            if (!selectInputEntry.getKey().equals(fetchValue)) continue;
            return true;
        }
        return false;
    }

    private List<RadioInputEntry> generateEntriesFromKeyValues(String[] keys, String[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Key / Values with unequal length");
        }
        ArrayList<RadioInputEntry> entriesToCreate = new ArrayList<RadioInputEntry>();
        for (int i = 0; i < keys.length; ++i) {
            entriesToCreate.add(this.generateEntry(keys[i], values[i]));
        }
        return entriesToCreate;
    }

    public RadioInputEntry generateEntry(String key, String value) {
        return new RadioInputEntry(key, value);
    }

    public String toString() {
        return String.format("RadioInput. name=%s", this.oneValueElement.name);
    }

    public List<RadioInputEntry> getEntries() {
        return this.entries;
    }

    public List<RadioInputEntryWithSelectedInfo> getEntryListWithSelected(String selectedKey) {
        ArrayList<RadioInputEntryWithSelectedInfo> resultList = new ArrayList<RadioInputEntryWithSelectedInfo>();
        this.entries.forEach(entry -> {
            boolean selected = false;
            if (entry.getKey().equals(selectedKey)) {
                selected = true;
            }
            resultList.add(new RadioInputEntryWithSelectedInfo(entry.key, entry.value, selected));
        });
        return resultList;
    }

    public class RadioInputEntryWithSelectedInfo
    extends RadioInputEntry {
        private final boolean selected;

        public RadioInputEntryWithSelectedInfo(String key, String value, boolean selected) {
            super(key, value);
            this.selected = selected;
        }

        public String toString() {
            return String.format("Key: %s Value: %s, Selected: %s", this.key, this.value, this.selected);
        }

        public boolean isSelected() {
            return this.selected;
        }
    }

    public class RadioInputEntry {
        protected final String key;
        protected final String value;

        public RadioInputEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

