/*
 * Decompiled with CFR 0.152.
 */
package jwebform.element;

import jwebform.element.structure.ElementResult;
import jwebform.element.structure.OneValueElementProcessor;
import jwebform.element.structure.SingleType;
import jwebform.element.structure.StaticElementInfo;
import jwebform.env.Env;

public class NumberType
implements SingleType {
    private final int initialNumber;
    public final OneValueElementProcessor oneValueElement;

    public NumberType(String name, int initialValue) {
        this.oneValueElement = new OneValueElementProcessor(name, Integer.toString(initialValue));
        this.initialNumber = initialValue;
    }

    @Override
    public ElementResult apply(Env.EnvWithSubmitInfo env) {
        String requestVal = env.getEnv().getRequest().getParameter(this.oneValueElement.name);
        String val = env.isSubmitted() ? requestVal : Integer.toString(this.initialNumber);
        int parsedNumber = 0;
        String parsedNumberVal = "";
        try {
            parsedNumber = Integer.parseInt(val);
            parsedNumberVal = Integer.toString(parsedNumber);
        }
        catch (NumberFormatException e) {
            parsedNumber = 0;
        }
        return ElementResult.builder().withValue(parsedNumberVal).withStaticElementInfo(new StaticElementInfo(this.oneValueElement.name, t -> "<!-- number -->", 1)).withValueObject(parsedNumber).build();
    }

    public String toString() {
        return String.format("NumberInput. name=%s", this.oneValueElement.name);
    }
}

