/*
 * Decompiled with CFR 0.152.
 */
package jwebform.element;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import jwebform.element.structure.ElementContainer;
import jwebform.element.structure.ElementResult;
import jwebform.element.structure.StaticElementInfo;
import jwebform.env.Env;
import jwebform.processors.ElementResults;
import jwebform.processors.ElementValdationResults;
import jwebform.validation.FormValidator;
import jwebform.validation.ValidationResult;

class DateTypeHelper {
    private final ElementContainer day;
    private final ElementContainer month;
    private final ElementContainer year;
    private final LocalDate initialValue;
    private final String name;

    public DateTypeHelper(ElementContainer day, ElementContainer month, ElementContainer year, LocalDate initialValue, String name) {
        this.day = day;
        this.month = month;
        this.year = year;
        this.initialValue = initialValue;
        this.name = name;
    }

    private LocalDate setupDateValue(LocalDate initialValue, String dayStr, String monthStr, String yearStr) {
        if (this.isEmpty(dayStr) && this.isEmpty(monthStr) && this.isEmpty(yearStr)) {
            return initialValue;
        }
        int dayInt = this.getDefaultValueFromRequest(dayStr);
        int monthInt = this.getDefaultValueFromRequest(monthStr);
        int yearInt = this.getDefaultValueFromRequest(yearStr);
        return LocalDate.of(yearInt, monthInt, dayInt);
    }

    private int getDefaultValueFromRequest(String input) {
        return Integer.parseInt(input);
    }

    public List<FormValidator> getValidators() {
        return Collections.singletonList(elements -> {
            ElementValdationResults validationResult = new ElementValdationResults();
            ElementResult dayResult = elements.get(this.day);
            ElementResult monthResult = elements.get(this.month);
            ElementResult yearResult = elements.get(this.year);
            try {
                this.setupDateValue(this.initialValue, dayResult.getValue(), monthResult.getValue(), yearResult.getValue());
            }
            catch (NumberFormatException | DateTimeException runtimeException) {
                // empty catch block
            }
            return validationResult;
        });
    }

    public ElementResult processDateVal(Env.EnvWithSubmitInfo env, ElementResults childs, String fallbackTypename) {
        LocalDate dateValue = this.initialValue;
        ValidationResult validationResult = ValidationResult.undefined();
        String dateValStr = "";
        if (env.isSubmitted()) {
            try {
                dateValue = this.setupDateValue(this.initialValue, childs.get(this.day).getValue(), childs.get(this.month).getValue(), childs.get(this.year).getValue());
                dateValStr = dateValue.format(DateTimeFormatter.ISO_DATE);
                validationResult = ValidationResult.ok();
            }
            catch (NumberFormatException | DateTimeException e) {
                validationResult = ValidationResult.fail("jformchecker.wrong_date_format", new Object[0]);
            }
        }
        ElementResult result = ElementResult.builder().withValue(dateValStr).withChilds(childs).withStaticElementInfo(new StaticElementInfo(this.name, t -> "<!-- " + fallbackTypename + " -->", 3)).withValueObject(dateValue).build();
        if (validationResult != ValidationResult.undefined()) {
            return result.cloneWithNewValidationResult(validationResult);
        }
        return result;
    }

    private boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }
}

