/*
 * Decompiled with CFR 0.152.
 */
package jwebform.element;

import jwebform.element.structure.ElementResult;
import jwebform.element.structure.SingleType;
import jwebform.element.structure.StaticElementInfo;
import jwebform.env.Env;

public class CheckBoxType
implements SingleType {
    private final String name;
    private final boolean initialValue;

    public CheckBoxType(String name, boolean initialValue) {
        this.name = name;
        this.initialValue = initialValue;
    }

    @Override
    public ElementResult apply(Env.EnvWithSubmitInfo env) {
        boolean checked;
        String requestVal = env.getEnv().getRequest().getParameter(this.name);
        String value = "true";
        if (!env.isSubmitted()) {
            value = "" + this.initialValue;
            checked = this.initialValue;
        } else {
            checked = true;
            if ("".equals(requestVal) || requestVal == null) {
                value = "";
                checked = false;
            }
        }
        return ElementResult.builder().withValue(value).withStaticElementInfo(new StaticElementInfo(this.name, t -> "<!-- checkbox -->", 1)).withValueObject(checked).build();
    }

    public String toString() {
        return String.format("CheckBoxInput. name=%s", this.name);
    }
}

