/*
 * Decompiled with CFR 0.152.
 */
package jwebform;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jwebform.element.structure.ElementContainer;
import jwebform.element.structure.ElementResult;
import jwebform.element.structure.ForceFileuploadMethod;
import jwebform.processors.ElementResults;
import jwebform.view.ProducerInfos;

public final class View {
    private final ElementResults elementResults;
    private final String formId;
    private final Method method;
    private final Html5Validation html5Validaiton;

    public View(String formId, ElementResults elementResults, Method method, Html5Validation html5Validation) {
        this.formId = formId;
        this.elementResults = elementResults;
        this.method = method;
        this.html5Validaiton = html5Validation;
    }

    public String getFormId() {
        return this.formId;
    }

    public String getMethod() {
        return this.method.name();
    }

    public boolean isUploadEnctypeRequired() {
        for (Map.Entry<ElementContainer, ElementResult> entry : this.elementResults) {
            if (!(entry.getKey().element instanceof ForceFileuploadMethod)) continue;
            return true;
        }
        return false;
    }

    public boolean isHtml5Validaiton() {
        return this.html5Validaiton == Html5Validation.ON;
    }

    public ProducerInfosContainer getProducerInfosContainer() {
        ArrayList<ProducerInfos> elementList = new ArrayList<ProducerInfos>();
        LinkedHashMap<String, ProducerInfos> elementMap = new LinkedHashMap<String, ProducerInfos>();
        ArrayList<String> names = new ArrayList<String>();
        int tabIndex = 1;
        for (Map.Entry<ElementContainer, ElementResult> entry : this.elementResults) {
            ElementResult elementResult = entry.getValue();
            ProducerInfos pi = new ProducerInfos(this.formId, tabIndex, elementResult, entry.getKey(), this.createProducerInfoChilds(elementResult.getChilds(), tabIndex));
            elementList.add(pi);
            elementMap.put(elementResult.getStaticElementInfo().getName(), pi);
            names.add(elementResult.getStaticElementInfo().getName());
            tabIndex += elementResult.getStaticElementInfo().getTabIndexIncrement();
        }
        return new ProducerInfosContainer(elementMap, elementList, names);
    }

    private List<ProducerInfos> createProducerInfoChilds(ElementResults childs, int tabIndex) {
        ArrayList<ProducerInfos> listOfPis = new ArrayList<ProducerInfos>();
        for (Map.Entry<ElementContainer, ElementResult> elem : childs) {
            listOfPis.add(new ProducerInfos(this.formId, tabIndex, elem.getValue(), elem.getKey()));
        }
        return listOfPis;
    }

    public static enum Html5Validation {
        ON,
        OFF;

    }

    public static enum Method {
        POST,
        GET;

    }

    public class ProducerInfosContainer {
        public final Map<String, ProducerInfos> piMap;
        public final List<ProducerInfos> piList;
        public final List<String> names;

        public ProducerInfosContainer(Map<String, ProducerInfos> piMap, List<ProducerInfos> piList, List<String> names) {
            this.piMap = piMap;
            this.piList = piList;
            this.names = names;
        }
    }
}

