/*
 * Decompiled with CFR 0.152.
 */
package jwebform;

import jwebform.View;
import jwebform.processors.ElementResults;

public class FormResult {
    private final String formId;
    private final ElementResults elementResults;
    private final boolean formIsValid;

    public FormResult(String formId, ElementResults elementResults, boolean formIsValid) {
        this.formId = formId;
        this.formIsValid = formIsValid;
        this.elementResults = elementResults;
    }

    public final boolean isOk() {
        return this.formIsValid;
    }

    public View getView(View.Html5Validation html5Validation) {
        return new View(this.formId, this.elementResults, View.Method.POST, html5Validation);
    }

    public View getView(View.Html5Validation html5Validation, View.Method method) {
        return new View(this.formId, this.elementResults, method, html5Validation);
    }

    public View getView(View.Method method) {
        return new View(this.formId, this.elementResults, method, View.Html5Validation.ON);
    }

    public View getView() {
        return new View(this.formId, this.elementResults, View.Method.POST, View.Html5Validation.ON);
    }

    public final ElementResults getElementResults() {
        return this.elementResults;
    }

    public final String getStringValue(String name) {
        return this.elementResults.getElementStringValue(name);
    }

    public final Object getObectValue(String name) {
        return this.elementResults.getObectValue(name);
    }

    public String getFormId() {
        return this.formId;
    }
}

