/*
 * Decompiled with CFR 0.152.
 */
package jwebform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jwebform.Form;
import jwebform.FormResult;
import jwebform.element.SimpleGroup;
import jwebform.element.builder.TypeBuilder;
import jwebform.element.structure.ElementContainer;
import jwebform.element.structure.GroupType;
import jwebform.element.structure.SingleType;
import jwebform.processors.FormResultBuilder;
import jwebform.validation.FormValidator;

public class FormBuilder {
    private String id = "id";
    private FormResultBuilder formResultBuilder;
    private GroupType group = new SimpleGroup(new ArrayList<ElementContainer>(), new ArrayList<FormValidator>());
    private List<ElementContainer> elementContainers = new ArrayList<ElementContainer>();
    private List<FormValidator> formValidators = new ArrayList<FormValidator>();
    private List<TypeBuilder> typeBuilders = new ArrayList<TypeBuilder>();
    private List<SingleType> singleTypes = new ArrayList<SingleType>();

    private FormBuilder(String id, FormResultBuilder formResultBuilder) {
        this.id = id;
        this.formResultBuilder = formResultBuilder;
    }

    public static FormBuilder simple() {
        return new FormBuilder("id", FormResult::new);
    }

    public static FormBuilder withId(String id) {
        return new FormBuilder(id, FormResult::new);
    }

    public static FormBuilder flexible(String id, FormResultBuilder fb) {
        return new FormBuilder(id, fb);
    }

    public Form build() {
        return new Form(this.id, this.buildGroup(), this.formResultBuilder);
    }

    private GroupType buildGroup() {
        this.elementContainers.addAll(this.processTypeBuilders());
        this.elementContainers.addAll(this.processSingleTypes());
        this.group.getChilds().addAll(this.elementContainers);
        this.group.getValidators(null).addAll(this.formValidators);
        return this.group;
    }

    private Collection<ElementContainer> processSingleTypes() {
        ArrayList<ElementContainer> ec = new ArrayList<ElementContainer>();
        for (SingleType element : this.singleTypes) {
            ec.add(new ElementContainer(element));
        }
        return ec;
    }

    private Collection<ElementContainer> processTypeBuilders() {
        ArrayList<ElementContainer> elList = new ArrayList<ElementContainer>();
        for (TypeBuilder typeBuilder : this.typeBuilders) {
            elList.add(typeBuilder.build());
        }
        return elList;
    }

    public FormBuilder group(GroupType group) {
        this.group = group;
        return this;
    }

    public FormBuilder elementContainer(List<ElementContainer> elList) {
        this.elementContainers.addAll(elList);
        return this;
    }

    public FormBuilder elementContainer(ElementContainer ... elList) {
        this.elementContainers.addAll(new ArrayList<ElementContainer>(Arrays.asList(elList)));
        return this;
    }

    public FormBuilder typeBuilder(List<TypeBuilder> typeBuilders) {
        this.typeBuilders.addAll(typeBuilders);
        return this;
    }

    public FormBuilder typeBuilder(TypeBuilder ... typeBuilder) {
        this.typeBuilders.addAll(new ArrayList<TypeBuilder>(Arrays.asList(typeBuilder)));
        return this;
    }

    public FormBuilder singleTypes(List<SingleType> singleTypeList) {
        this.singleTypes.addAll(singleTypeList);
        return this;
    }

    public FormBuilder singleTypes(SingleType ... singleType) {
        this.singleTypes.addAll(new ArrayList<SingleType>(Arrays.asList(singleType)));
        return this;
    }

    public FormBuilder validation(List<FormValidator> formValidation) {
        this.formValidators.addAll(formValidation);
        return this;
    }

    public FormBuilder validation(FormValidator ... formValidation) {
        this.formValidators.addAll(new ArrayList<FormValidator>(Arrays.asList(formValidation)));
        return this;
    }

    public static <T> T[] array(T ... values) {
        return values;
    }
}

