/*
 * Decompiled with CFR 0.152.
 */
package jwebform.resultprocessor;

import jwebform.FormResult;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.SingleFieldType;
import jwebform.processor.FieldResults;
import jwebform.resultprocessor.Logger;
import jwebform.resultprocessor.ResultProcessor;

public class FormLogger {
    private final FormResult formResult;
    private final Logger logger;

    public FormLogger(FormResult formResult, Logger logger) {
        this.formResult = formResult;
        this.logger = logger;
    }

    public void logForm() {
        StringBuilder b = new StringBuilder("\n");
        this.debugOutput(this.formResult.getFieldResults(), b, "");
        this.logger.log(b.toString());
    }

    private String debugOutput(FieldResults fieldResults, StringBuilder b, String indent) {
        fieldResults.forEach(entry -> {
            Field container = (Field)entry.getKey();
            FieldResult result = (FieldResult)entry.getValue();
            if (container.fieldType instanceof SingleFieldType) {
                this.appendSingleType(b, container, result, indent);
            } else {
                this.appendSingleType(b, container, result, indent);
                this.debugOutput(result.getChilds(), b, indent + "---- ");
            }
        });
        return "Form valid: " + this.formResult.isValid() + "\n " + b.toString();
    }

    private void appendSingleType(StringBuilder b, Field container, FieldResult result, String indent) {
        b.append("---------------------\n").append(indent).append("Typ    : ").append(container.fieldType.getClass().getName()).append("\n").append(indent).append("Name   : ").append(result.getStaticFieldInfo().getName()).append("\n").append(indent).append("Value  : ").append(result.getValue()).append("\n").append(indent).append("Valdid : ").append(result.getValidationResult().isValid() ? "OK" : "Not OK").append("\n");
    }

    public static class LoggingFormResultProcessor
    implements ResultProcessor<FormLogger> {
        private final Logger logger;

        public LoggingFormResultProcessor(Logger logger) {
            this.logger = logger;
        }

        @Override
        public FormLogger process(FormResult formResult) {
            return new FormLogger(formResult, this.logger);
        }
    }
}

