/*
 * Decompiled with CFR 0.152.
 */
package jwebform.processor;

import java.util.HashSet;
import java.util.Map;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.processor.FieldResults;
import jwebform.processor.PostProcessor;

public class CheckDoubleFieldsPostProcessor
implements PostProcessor {
    @Override
    public FieldResults postProcess(FieldResults results) {
        HashSet<String> availableFields = new HashSet<String>();
        for (Map.Entry<Field, FieldResult> entry : results) {
            if (entry.getValue().getStaticFieldInfo().getName() == "" || availableFields.add(entry.getValue().getStaticFieldInfo().getName())) continue;
            throw new DoubleTakenNameException(entry.getValue().getStaticFieldInfo().getName());
        }
        return results;
    }

    public class DoubleTakenNameException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DoubleTakenNameException(String name) {
            super(String.format("The name '%s' was taken more than once for this form. Make sure, that you use eache name of each fieldType only once!", name));
        }
    }
}

