/*
 * Decompiled with CFR 0.152.
 */
package jwebform.field.structure;

import jwebform.field.structure.StaticFieldInfo;
import jwebform.processor.FieldResults;
import jwebform.validation.ValidationResult;

public final class FieldResult {
    private final ValidationResult validationResult;
    private final String value;
    private final Object valueObject;
    private final StaticFieldInfo staticFieldInfo;
    private final FieldResults childs;
    private static final String EMPTY_STRING = "";
    public static final String NO_NAME = "";
    public static final FieldResults NOCHILDS = new FieldResults();

    private FieldResult(Builder builder) {
        this.validationResult = builder.validationResult;
        this.value = builder.value;
        this.valueObject = builder.valueObject;
        this.staticFieldInfo = builder.internalStaticFieldInfo;
        this.childs = builder.childs;
    }

    public FieldResult ofValidationResult(ValidationResult vr) {
        return FieldResult.builder().withChilds(this.childs).withStaticFieldInfo(this.staticFieldInfo).withValidationResult(vr).withValue(this.value).withValueObject(this.valueObject).build();
    }

    public FieldResult cloneWithChilds(FieldResults childs) {
        return FieldResult.builder().withChilds(childs).withStaticFieldInfo(this.staticFieldInfo).withValidationResult(this.validationResult).withValue(this.value).withValueObject(this.valueObject).build();
    }

    public FieldResult cloneWithNewValidationResult(ValidationResult newValidationResult) {
        return FieldResult.builder().withChilds(this.childs).withStaticFieldInfo(this.staticFieldInfo).withValidationResult(newValidationResult).withValue(this.value).withValueObject(this.valueObject).build();
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public String getValue() {
        return this.value;
    }

    public FieldResults getChilds() {
        return this.childs;
    }

    public StaticFieldInfo getStaticFieldInfo() {
        return this.staticFieldInfo;
    }

    public Object getValueObject() {
        return this.valueObject;
    }

    public String toString() {
        return String.format("FieldResult: %s", this.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ValidationResult validationResult = ValidationResult.undefined();
        private String value = "";
        private Object valueObject = "";
        private StaticFieldInfo internalStaticFieldInfo;
        private FieldResults childs = new FieldResults();

        private Builder() {
        }

        public Builder withValidationResult(ValidationResult validationResult) {
            this.validationResult = validationResult;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withValueObject(Object valueObject) {
            this.valueObject = valueObject;
            return this;
        }

        public Builder withStaticFieldInfo(StaticFieldInfo staticFieldInfo) {
            this.internalStaticFieldInfo = staticFieldInfo;
            return this;
        }

        public Builder withChilds(FieldResults childs) {
            this.childs = childs;
            return this;
        }

        public FieldResult build() {
            if (this.valueObject == "" && this.value != "") {
                this.valueObject = this.value;
            }
            return new FieldResult(this);
        }
    }
}

