/*
 * Decompiled with CFR 0.152.
 */
package jwebform.field.structure;

public class Decoration {
    private final String label;
    private final String helptext;
    private final String placeholder;
    public static final String EMPTY = "";

    private Decoration(Builder builder) {
        this.label = builder.label;
        this.helptext = builder.helptext;
        this.placeholder = builder.placeholder;
    }

    public Decoration(String label) {
        this(label, EMPTY, EMPTY);
    }

    public Decoration(String label, String helptext, String placeholder) {
        this.label = label;
        this.helptext = helptext;
        this.placeholder = placeholder;
    }

    public Decoration(String label, String helptext) {
        this(label, helptext, EMPTY);
    }

    public String getLabel() {
        return this.label;
    }

    public String getHelptext() {
        return this.helptext;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String label;
        private String helptext = "";
        private String placeholder = "";

        private Builder() {
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withHelptext(String helptext) {
            this.helptext = helptext;
            return this;
        }

        public Builder withPlaceholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Decoration build() {
            return new Decoration(this);
        }
    }
}

