/*
 * Decompiled with CFR 0.152.
 */
package jwebform.field;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import jwebform.env.Env;
import jwebform.field.TextType;
import jwebform.field.helper.DateTypeHelper;
import jwebform.field.structure.Decoration;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.GroupFieldType;
import jwebform.processor.FieldResults;
import jwebform.validation.FormValidator;
import jwebform.validation.criteria.Criteria;

public class TextDateType
implements GroupFieldType {
    private final Field day;
    private final Field month;
    private final Field year;
    private final DateTypeHelper helper;

    public TextDateType(String name, LocalDate initialValue) {
        this.day = new TextType(name + "_day", String.valueOf(initialValue.getDayOfMonth())).of(new Decoration("jwebform.select.day"), Criteria.number());
        this.month = new TextType(name + "_month", String.valueOf(initialValue.getMonthValue())).of(new Decoration("jwebform.select.month"), Criteria.number());
        this.year = new TextType(name + "_year", String.valueOf(initialValue.getYear())).of(new Decoration("jwebform.select.year"), Criteria.number());
        this.helper = new DateTypeHelper(this.day, this.month, this.year, name);
    }

    @Override
    public List<Field> getChilds() {
        return Arrays.asList(this.day, this.month, this.year);
    }

    @Override
    public List<FormValidator> getValidators(Field source) {
        return this.helper.getValidators();
    }

    @Override
    public FieldResult process(Env.EnvWithSubmitInfo env, FieldResults childs) {
        return this.helper.processDateVal(env, childs, "text Date");
    }
}

