/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.view.jasperreports.AbstractJasperReportsView;
import org.springframework.web.servlet.view.jasperreports.JasperReportsCsvView;
import org.springframework.web.servlet.view.jasperreports.JasperReportsHtmlView;
import org.springframework.web.servlet.view.jasperreports.JasperReportsPdfView;
import org.springframework.web.servlet.view.jasperreports.JasperReportsXlsView;
import org.springframework.web.servlet.view.jasperreports.JasperReportsXlsxView;

public class JasperReportsMultiFormatView
extends AbstractJasperReportsView {
    public static final String DEFAULT_FORMAT_KEY = "format";
    private String formatKey = "format";
    private Map<String, Class<? extends AbstractJasperReportsView>> formatMappings = new HashMap<String, Class<? extends AbstractJasperReportsView>>(4);
    private Properties contentDispositionMappings;

    public JasperReportsMultiFormatView() {
        this.formatMappings.put("csv", JasperReportsCsvView.class);
        this.formatMappings.put("html", JasperReportsHtmlView.class);
        this.formatMappings.put("pdf", JasperReportsPdfView.class);
        this.formatMappings.put("xls", JasperReportsXlsView.class);
        this.formatMappings.put("xlsx", JasperReportsXlsxView.class);
    }

    public void setFormatKey(String formatKey) {
        this.formatKey = formatKey;
    }

    public void setFormatMappings(Map<String, Class<? extends AbstractJasperReportsView>> formatMappings) {
        if (CollectionUtils.isEmpty(formatMappings)) {
            throw new IllegalArgumentException("'formatMappings' must not be empty");
        }
        this.formatMappings = formatMappings;
    }

    public void setContentDispositionMappings(Properties mappings) {
        this.contentDispositionMappings = mappings;
    }

    public Properties getContentDispositionMappings() {
        if (this.contentDispositionMappings == null) {
            this.contentDispositionMappings = new Properties();
        }
        return this.contentDispositionMappings;
    }

    @Override
    protected boolean generatesDownloadContent() {
        return true;
    }

    @Override
    protected void renderReport(JasperPrint populatedReport, Map<String, Object> model, HttpServletResponse response) throws Exception {
        Class<? extends AbstractJasperReportsView> viewClass;
        String format = (String)model.get(this.formatKey);
        if (format == null) {
            throw new IllegalArgumentException("No format found in model");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rendering report using format mapping key [" + format + "]");
        }
        if ((viewClass = this.formatMappings.get(format)) == null) {
            throw new IllegalArgumentException("Format discriminator [" + format + "] is not a configured mapping");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rendering report using view class [" + viewClass.getName() + "]");
        }
        AbstractJasperReportsView view = BeanUtils.instantiateClass(viewClass);
        view.setExporterParameters(this.getExporterParameters());
        view.setConvertedExporterParameters(this.getConvertedExporterParameters());
        this.populateContentDispositionIfNecessary(response, format);
        view.renderReport(populatedReport, model, response);
    }

    private void populateContentDispositionIfNecessary(HttpServletResponse response, String format) {
        String header;
        if (this.contentDispositionMappings != null && (header = this.contentDispositionMappings.getProperty(format)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting Content-Disposition header to: [" + header + "]");
            }
            response.setHeader("Content-Disposition", header);
        }
    }
}

