/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.DigestUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.ResourceTransformerSupport;
import org.springframework.web.servlet.resource.TransformedResource;

public class AppCacheManifestTransformer
extends ResourceTransformerSupport {
    private static final String MANIFEST_HEADER = "CACHE MANIFEST";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final Log logger = LogFactory.getLog(AppCacheManifestTransformer.class);
    private final Map<String, SectionTransformer> sectionTransformers = new HashMap<String, SectionTransformer>();
    private final String fileExtension;

    public AppCacheManifestTransformer() {
        this("manifest");
    }

    public AppCacheManifestTransformer(String fileExtension) {
        this.fileExtension = fileExtension;
        NoOpSection noOpSection = new NoOpSection();
        this.sectionTransformers.put(MANIFEST_HEADER, noOpSection);
        this.sectionTransformers.put("NETWORK:", noOpSection);
        this.sectionTransformers.put("FALLBACK:", noOpSection);
        this.sectionTransformers.put("CACHE:", new CacheSection());
    }

    @Override
    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        if (!this.fileExtension.equals(StringUtils.getFilenameExtension((resource = transformerChain.transform(request, resource)).getFilename()))) {
            return resource;
        }
        byte[] bytes = FileCopyUtils.copyToByteArray(resource.getInputStream());
        String content = new String(bytes, DEFAULT_CHARSET);
        if (!content.startsWith(MANIFEST_HEADER)) {
            if (logger.isTraceEnabled()) {
                logger.trace("AppCache manifest does not start with 'CACHE MANIFEST', skipping: " + resource);
            }
            return resource;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Transforming resource: " + resource);
        }
        StringWriter contentWriter = new StringWriter();
        HashBuilder hashBuilder = new HashBuilder(content.length());
        Scanner scanner = new Scanner(content);
        SectionTransformer currentTransformer = this.sectionTransformers.get(MANIFEST_HEADER);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (this.sectionTransformers.containsKey(line.trim())) {
                currentTransformer = this.sectionTransformers.get(line.trim());
                contentWriter.write(line + "\n");
                hashBuilder.appendString(line);
                continue;
            }
            contentWriter.write(currentTransformer.transform(line, hashBuilder, resource, transformerChain, request) + "\n");
        }
        String hash = hashBuilder.build();
        contentWriter.write("\n# Hash: " + hash);
        if (logger.isTraceEnabled()) {
            logger.trace("AppCache file: [" + resource.getFilename() + "] hash: [" + hash + "]");
        }
        return new TransformedResource(resource, contentWriter.toString().getBytes(DEFAULT_CHARSET));
    }

    private static class HashBuilder {
        private final ByteArrayOutputStream baos;

        public HashBuilder(int initialSize) {
            this.baos = new ByteArrayOutputStream(initialSize);
        }

        public void appendResource(Resource resource) throws IOException {
            byte[] content = FileCopyUtils.copyToByteArray(resource.getInputStream());
            this.baos.write(DigestUtils.md5Digest(content));
        }

        public void appendString(String content) throws IOException {
            this.baos.write(content.getBytes(DEFAULT_CHARSET));
        }

        public String build() {
            return DigestUtils.md5DigestAsHex(this.baos.toByteArray());
        }
    }

    private class CacheSection
    implements SectionTransformer {
        private static final String COMMENT_DIRECTIVE = "#";

        private CacheSection() {
        }

        @Override
        public String transform(String line, HashBuilder builder, Resource resource, ResourceTransformerChain transformerChain, HttpServletRequest request) throws IOException {
            if (this.isLink(line) && !this.hasScheme(line)) {
                ResourceResolverChain resolverChain = transformerChain.getResolverChain();
                Resource appCacheResource = resolverChain.resolveResource(null, line, Collections.singletonList(resource));
                String path = AppCacheManifestTransformer.this.resolveUrlPath(line, request, resource, transformerChain);
                builder.appendResource(appCacheResource);
                if (logger.isTraceEnabled()) {
                    logger.trace("Link modified: " + path + " (original: " + line + ")");
                }
                return path;
            }
            builder.appendString(line);
            return line;
        }

        private boolean hasScheme(String link) {
            int schemeIndex = link.indexOf(58);
            return link.startsWith("//") || schemeIndex > 0 && !link.substring(0, schemeIndex).contains("/");
        }

        private boolean isLink(String line) {
            return StringUtils.hasText(line) && !line.startsWith(COMMENT_DIRECTIVE);
        }
    }

    private static class NoOpSection
    implements SectionTransformer {
        private NoOpSection() {
        }

        @Override
        public String transform(String line, HashBuilder builder, Resource resource, ResourceTransformerChain transformerChain, HttpServletRequest request) throws IOException {
            builder.appendString(line);
            return line;
        }
    }

    private static interface SectionTransformer {
        public String transform(String var1, HashBuilder var2, Resource var3, ResourceTransformerChain var4, HttpServletRequest var5) throws IOException;
    }
}

