/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.FileSessionDataStore;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.Compression;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.embedded.jetty.JasperInitializer;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedErrorHandler;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainer;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedWebAppContext;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.context.embedded.jetty.ServletContextInitializerConfiguration;
import org.springframework.boot.web.servlet.ErrorPage;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class JettyEmbeddedServletContainerFactory
extends AbstractEmbeddedServletContainerFactory
implements ResourceLoaderAware {
    private static final String GZIP_HANDLER_JETTY_9_2 = "org.eclipse.jetty.servlets.gzip.GzipHandler";
    private static final String GZIP_HANDLER_JETTY_8 = "org.eclipse.jetty.server.handler.GzipHandler";
    private static final String GZIP_HANDLER_JETTY_9_3 = "org.eclipse.jetty.server.handler.gzip.GzipHandler";
    private static final String CONNECTOR_JETTY_8 = "org.eclipse.jetty.server.nio.SelectChannelConnector";
    private static final String SESSION_JETTY_9_3 = "org.eclipse.jetty.server.session.HashSessionManager";
    private List<Configuration> configurations = new ArrayList<Configuration>();
    private boolean useForwardHeaders;
    private int acceptors = -1;
    private int selectors = -1;
    private List<JettyServerCustomizer> jettyServerCustomizers = new ArrayList<JettyServerCustomizer>();
    private ResourceLoader resourceLoader;
    private ThreadPool threadPool;

    public JettyEmbeddedServletContainerFactory() {
    }

    public JettyEmbeddedServletContainerFactory(int port) {
        super(port);
    }

    public JettyEmbeddedServletContainerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    @Override
    public EmbeddedServletContainer getEmbeddedServletContainer(ServletContextInitializer ... initializers) {
        JettyEmbeddedWebAppContext context = new JettyEmbeddedWebAppContext();
        int port = this.getPort() >= 0 ? this.getPort() : 0;
        InetSocketAddress address = new InetSocketAddress(this.getAddress(), port);
        Server server = this.createServer(address);
        this.configureWebAppContext(context, initializers);
        server.setHandler(this.addHandlerWrappers((Handler)context));
        this.logger.info("Server initialized with port: " + port);
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            this.configureSsl(sslContextFactory, this.getSsl());
            AbstractConnector connector = this.getSslServerConnectorFactory().createConnector(server, sslContextFactory, address);
            server.setConnectors(new Connector[]{connector});
        }
        for (JettyServerCustomizer customizer : this.getServerCustomizers()) {
            customizer.customize(server);
        }
        if (this.useForwardHeaders) {
            new ForwardHeadersCustomizer().customize(server);
        }
        return this.getJettyEmbeddedServletContainer(server);
    }

    private Server createServer(InetSocketAddress address) {
        Server server = ClassUtils.hasConstructor(Server.class, ThreadPool.class) ? new Jetty9ServerFactory().createServer(this.getThreadPool()) : new Jetty8ServerFactory().createServer(this.getThreadPool());
        server.setConnectors(new Connector[]{this.createConnector(address, server)});
        return server;
    }

    private AbstractConnector createConnector(InetSocketAddress address, Server server) {
        if (ClassUtils.isPresent(CONNECTOR_JETTY_8, this.getClass().getClassLoader())) {
            return new Jetty8ConnectorFactory().createConnector(server, address, this.acceptors, this.selectors);
        }
        return new Jetty9ConnectorFactory().createConnector(server, address, this.acceptors, this.selectors);
    }

    private Handler addHandlerWrappers(Handler handler) {
        if (this.getCompression() != null && this.getCompression().getEnabled()) {
            handler = this.applyWrapper(handler, this.createGzipHandler());
        }
        if (StringUtils.hasText(this.getServerHeader())) {
            handler = this.applyWrapper(handler, new ServerHeaderHandler(this.getServerHeader()));
        }
        return handler;
    }

    private Handler applyWrapper(Handler handler, HandlerWrapper wrapper) {
        wrapper.setHandler(handler);
        return wrapper;
    }

    private HandlerWrapper createGzipHandler() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (ClassUtils.isPresent(GZIP_HANDLER_JETTY_9_2, classLoader)) {
            return new Jetty92GzipHandlerFactory().createGzipHandler(this.getCompression());
        }
        if (ClassUtils.isPresent(GZIP_HANDLER_JETTY_8, this.getClass().getClassLoader())) {
            return new Jetty8GzipHandlerFactory().createGzipHandler(this.getCompression());
        }
        if (ClassUtils.isPresent(GZIP_HANDLER_JETTY_9_3, this.getClass().getClassLoader())) {
            return new Jetty93GzipHandlerFactory().createGzipHandler(this.getCompression());
        }
        throw new IllegalStateException("Compression is enabled, but GzipHandler is not on the classpath");
    }

    private SslServerConnectorFactory getSslServerConnectorFactory() {
        if (ClassUtils.isPresent("org.eclipse.jetty.server.ssl.SslSocketConnector", null)) {
            return new Jetty8SslServerConnectorFactory();
        }
        return new Jetty9SslServerConnectorFactory();
    }

    protected void configureSsl(SslContextFactory factory, Ssl ssl) {
        factory.setProtocol(ssl.getProtocol());
        this.configureSslClientAuth(factory, ssl);
        this.configureSslPasswords(factory, ssl);
        factory.setCertAlias(ssl.getKeyAlias());
        if (!ObjectUtils.isEmpty(ssl.getCiphers())) {
            factory.setIncludeCipherSuites(ssl.getCiphers());
            factory.setExcludeCipherSuites(new String[0]);
        }
        if (ssl.getEnabledProtocols() != null) {
            factory.setIncludeProtocols(ssl.getEnabledProtocols());
        }
        if (this.getSslStoreProvider() != null) {
            try {
                factory.setKeyStore(this.getSslStoreProvider().getKeyStore());
                factory.setTrustStore(this.getSslStoreProvider().getTrustStore());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to set SSL store", ex);
            }
        } else {
            this.configureSslKeyStore(factory, ssl);
            this.configureSslTrustStore(factory, ssl);
        }
    }

    private void configureSslClientAuth(SslContextFactory factory, Ssl ssl) {
        if (ssl.getClientAuth() == Ssl.ClientAuth.NEED) {
            factory.setNeedClientAuth(true);
            factory.setWantClientAuth(true);
        } else if (ssl.getClientAuth() == Ssl.ClientAuth.WANT) {
            factory.setWantClientAuth(true);
        }
    }

    private void configureSslPasswords(SslContextFactory factory, Ssl ssl) {
        if (ssl.getKeyStorePassword() != null) {
            factory.setKeyStorePassword(ssl.getKeyStorePassword());
        }
        if (ssl.getKeyPassword() != null) {
            factory.setKeyManagerPassword(ssl.getKeyPassword());
        }
    }

    private void configureSslKeyStore(SslContextFactory factory, Ssl ssl) {
        try {
            URL url = ResourceUtils.getURL(ssl.getKeyStore());
            factory.setKeyStoreResource(Resource.newResource((URL)url));
        }
        catch (IOException ex) {
            throw new EmbeddedServletContainerException("Could not find key store '" + ssl.getKeyStore() + "'", ex);
        }
        if (ssl.getKeyStoreType() != null) {
            factory.setKeyStoreType(ssl.getKeyStoreType());
        }
        if (ssl.getKeyStoreProvider() != null) {
            factory.setKeyStoreProvider(ssl.getKeyStoreProvider());
        }
    }

    private void configureSslTrustStore(SslContextFactory factory, Ssl ssl) {
        if (ssl.getTrustStorePassword() != null) {
            factory.setTrustStorePassword(ssl.getTrustStorePassword());
        }
        if (ssl.getTrustStore() != null) {
            try {
                URL url = ResourceUtils.getURL(ssl.getTrustStore());
                factory.setTrustStoreResource(Resource.newResource((URL)url));
            }
            catch (IOException ex) {
                throw new EmbeddedServletContainerException("Could not find trust store '" + ssl.getTrustStore() + "'", ex);
            }
        }
        if (ssl.getTrustStoreType() != null) {
            factory.setTrustStoreType(ssl.getTrustStoreType());
        }
        if (ssl.getTrustStoreProvider() != null) {
            factory.setTrustStoreProvider(ssl.getTrustStoreProvider());
        }
    }

    protected final void configureWebAppContext(WebAppContext context, ServletContextInitializer ... initializers) {
        String contextPath;
        Assert.notNull(context, "Context must not be null");
        context.setTempDirectory(this.getTempDirectory());
        if (this.resourceLoader != null) {
            context.setClassLoader(this.resourceLoader.getClassLoader());
        }
        context.setContextPath(StringUtils.hasLength(contextPath = this.getContextPath()) ? contextPath : "/");
        context.setDisplayName(this.getDisplayName());
        this.configureDocumentRoot(context);
        if (this.isRegisterDefaultServlet()) {
            this.addDefaultServlet(context);
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet(context);
            context.addBean((Object)new JasperInitializer(context), true);
        }
        this.addLocaleMappings(context);
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        Configuration[] configurations = this.getWebAppContextConfigurations(context, initializersToUse);
        context.setConfigurations(configurations);
        context.setThrowUnavailableOnStartupException(true);
        this.configureSession(context);
        this.postProcessWebAppContext(context);
    }

    private void configureSession(WebAppContext context) {
        SessionConfigurer configurer = this.getSessionConfigurer();
        configurer.configure(context, this.getSessionTimeout(), this.isPersistSession(), new SessionDirectory(){

            @Override
            public File get() {
                return JettyEmbeddedServletContainerFactory.this.getValidSessionStoreDir();
            }
        });
    }

    private void addLocaleMappings(WebAppContext context) {
        for (Map.Entry<Locale, Charset> entry : this.getLocaleCharsetMappings().entrySet()) {
            Locale locale = entry.getKey();
            Charset charset = entry.getValue();
            context.addLocaleEncoding(locale.toString(), charset.toString());
        }
    }

    private SessionConfigurer getSessionConfigurer() {
        if (ClassUtils.isPresent(SESSION_JETTY_9_3, this.getClass().getClassLoader())) {
            return new Jetty93SessionConfigurer();
        }
        return new Jetty94SessionConfigurer();
    }

    private File getTempDirectory() {
        String temp = System.getProperty("java.io.tmpdir");
        return temp != null ? new File(temp) : null;
    }

    private void configureDocumentRoot(WebAppContext handler) {
        File root = this.getValidDocumentRoot();
        root = root != null ? root : this.createTempDir("jetty-docbase");
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.add(root.isDirectory() ? Resource.newResource((File)root.getCanonicalFile()) : JarResource.newJarResource((Resource)Resource.newResource((File)root)));
            for (URL resourceJarUrl : this.getUrlsOfJarsWithMetaInfResources()) {
                Resource resource = this.createResource(resourceJarUrl);
                if (!resource.exists() || !resource.isDirectory()) continue;
                resources.add(resource);
            }
            handler.setBaseResource((Resource)new ResourceCollection(resources.toArray(new Resource[resources.size()])));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Resource createResource(URL url) throws Exception {
        File file;
        if ("file".equals(url.getProtocol()) && (file = new File(url.toURI())).isFile()) {
            return Resource.newResource((String)("jar:" + url + "!/META-INF/resources"));
        }
        return Resource.newResource((String)(url + "META-INF/resources"));
    }

    protected final void addDefaultServlet(WebAppContext context) {
        Assert.notNull(context, "Context must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("default");
        holder.setClassName("org.eclipse.jetty.servlet.DefaultServlet");
        holder.setInitParameter("dirAllowed", "false");
        holder.setInitOrder(1);
        context.getServletHandler().addServletWithMapping(holder, "/");
        context.getServletHandler().getServletMapping("/").setDefault(true);
    }

    protected final void addJspServlet(WebAppContext context) {
        Assert.notNull(context, "Context must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("jsp");
        holder.setClassName(this.getJspServlet().getClassName());
        holder.setInitParameter("fork", "false");
        holder.setInitParameters(this.getJspServlet().getInitParameters());
        holder.setInitOrder(3);
        context.getServletHandler().addServlet(holder);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("jsp");
        mapping.setPathSpecs(new String[]{"*.jsp", "*.jspx"});
        context.getServletHandler().addServletMapping(mapping);
    }

    protected Configuration[] getWebAppContextConfigurations(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        configurations.add(this.getServletContextInitializerConfiguration(webAppContext, initializers));
        configurations.addAll(this.getConfigurations());
        configurations.add(this.getErrorPageConfiguration());
        configurations.add(this.getMimeTypeConfiguration());
        return configurations.toArray(new Configuration[configurations.size()]);
    }

    private Configuration getErrorPageConfiguration() {
        return new AbstractConfiguration(){

            public void configure(WebAppContext context) throws Exception {
                ErrorHandler errorHandler = context.getErrorHandler();
                context.setErrorHandler((ErrorHandler)new JettyEmbeddedErrorHandler(errorHandler));
                JettyEmbeddedServletContainerFactory.this.addJettyErrorPages(errorHandler, JettyEmbeddedServletContainerFactory.this.getErrorPages());
            }
        };
    }

    private Configuration getMimeTypeConfiguration() {
        return new AbstractConfiguration(){

            public void configure(WebAppContext context) throws Exception {
                MimeTypes mimeTypes = context.getMimeTypes();
                for (MimeMappings.Mapping mapping : JettyEmbeddedServletContainerFactory.this.getMimeMappings()) {
                    mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
                }
            }
        };
    }

    protected Configuration getServletContextInitializerConfiguration(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        return new ServletContextInitializerConfiguration(initializers);
    }

    protected void postProcessWebAppContext(WebAppContext webAppContext) {
    }

    protected JettyEmbeddedServletContainer getJettyEmbeddedServletContainer(Server server) {
        return new JettyEmbeddedServletContainer(server, this.getPort() >= 0);
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    public void setAcceptors(int acceptors) {
        this.acceptors = acceptors;
    }

    public void setSelectors(int selectors) {
        this.selectors = selectors;
    }

    public void setServerCustomizers(Collection<? extends JettyServerCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        this.jettyServerCustomizers = new ArrayList<JettyServerCustomizer>(customizers);
    }

    public Collection<JettyServerCustomizer> getServerCustomizers() {
        return this.jettyServerCustomizers;
    }

    public void addServerCustomizers(JettyServerCustomizer ... customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        this.jettyServerCustomizers.addAll(Arrays.asList(customizers));
    }

    public void setConfigurations(Collection<? extends Configuration> configurations) {
        Assert.notNull(configurations, "Configurations must not be null");
        this.configurations = new ArrayList<Configuration>(configurations);
    }

    public Collection<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void addConfigurations(Configuration ... configurations) {
        Assert.notNull(configurations, "Configurations must not be null");
        this.configurations.addAll(Arrays.asList(configurations));
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    private void addJettyErrorPages(ErrorHandler errorHandler, Collection<ErrorPage> errorPages) {
        if (errorHandler instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler handler = (ErrorPageErrorHandler)errorHandler;
            for (ErrorPage errorPage : errorPages) {
                if (errorPage.isGlobal()) {
                    handler.addErrorPage("org.eclipse.jetty.server.error_page.global", errorPage.getPath());
                    continue;
                }
                if (errorPage.getExceptionName() != null) {
                    handler.addErrorPage(errorPage.getExceptionName(), errorPage.getPath());
                    continue;
                }
                handler.addErrorPage(errorPage.getStatusCode(), errorPage.getPath());
            }
        }
    }

    private static class Jetty94SessionConfigurer
    implements SessionConfigurer {
        private Jetty94SessionConfigurer() {
        }

        @Override
        public void configure(WebAppContext context, int timeout, boolean persist, SessionDirectory sessionDirectory) {
            SessionHandler handler = context.getSessionHandler();
            handler.setMaxInactiveInterval(timeout > 0 ? timeout : -1);
            if (persist) {
                DefaultSessionCache cache = new DefaultSessionCache(handler);
                FileSessionDataStore store = new FileSessionDataStore();
                store.setStoreDir(sessionDirectory.get());
                cache.setSessionDataStore((SessionDataStore)store);
                handler.setSessionCache((SessionCache)cache);
            }
        }
    }

    private static class Jetty93SessionConfigurer
    implements SessionConfigurer {
        private Jetty93SessionConfigurer() {
        }

        @Override
        public void configure(WebAppContext context, int timeout, boolean persist, SessionDirectory sessionDirectory) {
            SessionHandler handler = context.getSessionHandler();
            Object manager = this.getSessionManager(handler);
            this.setMaxInactiveInterval(manager, timeout > 0 ? timeout : -1);
            if (persist) {
                Class<?> hashSessionManagerClass = ClassUtils.resolveClassName(JettyEmbeddedServletContainerFactory.SESSION_JETTY_9_3, handler.getClass().getClassLoader());
                Assert.isInstanceOf(hashSessionManagerClass, manager, "Unable to use persistent sessions");
                this.configurePersistSession(manager, sessionDirectory);
            }
        }

        private Object getSessionManager(SessionHandler handler) {
            Method method = ReflectionUtils.findMethod(SessionHandler.class, "getSessionManager");
            return ReflectionUtils.invokeMethod(method, handler);
        }

        private void setMaxInactiveInterval(Object manager, int interval) {
            Method method = ReflectionUtils.findMethod(manager.getClass(), "setMaxInactiveInterval", Integer.TYPE);
            ReflectionUtils.invokeMethod(method, manager, interval);
        }

        private void configurePersistSession(Object manager, SessionDirectory sessionDirectory) {
            try {
                this.setStoreDirectory(manager, sessionDirectory.get());
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void setStoreDirectory(Object manager, File file) throws IOException {
            Method method = ReflectionUtils.findMethod(manager.getClass(), "setStoreDirectory", File.class);
            ReflectionUtils.invokeMethod(method, manager, file);
        }
    }

    private static interface SessionConfigurer {
        public void configure(WebAppContext var1, int var2, boolean var3, SessionDirectory var4);
    }

    private static interface SessionDirectory {
        public File get();
    }

    private static class Jetty9ServerFactory
    implements ServerFactory {
        private Jetty9ServerFactory() {
        }

        @Override
        public Server createServer(ThreadPool threadPool) {
            return new Server(threadPool);
        }
    }

    private static class Jetty8ServerFactory
    implements ServerFactory {
        private Jetty8ServerFactory() {
        }

        @Override
        public Server createServer(ThreadPool threadPool) {
            Server server = new Server();
            try {
                ReflectionUtils.findMethod(Server.class, "setThreadPool", ThreadPool.class).invoke((Object)server, threadPool);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to configure Jetty 8 ThreadPool", ex);
            }
            try {
                ReflectionUtils.findMethod(Server.class, "setSendServerVersion", Boolean.TYPE).invoke((Object)server, false);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to disable Server header", ex);
            }
            return server;
        }
    }

    private static interface ServerFactory {
        public Server createServer(ThreadPool var1);
    }

    private static class Jetty9ConnectorFactory
    implements ConnectorFactory {
        private Jetty9ConnectorFactory() {
        }

        @Override
        public AbstractConnector createConnector(Server server, InetSocketAddress address, int acceptors, int selectors) {
            ServerConnector connector = new ServerConnector(server, acceptors, selectors);
            connector.setHost(address.getHostString());
            connector.setPort(address.getPort());
            for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
                if (!(connectionFactory instanceof HttpConfiguration.ConnectionFactory)) continue;
                ((HttpConfiguration.ConnectionFactory)connectionFactory).getHttpConfiguration().setSendServerVersion(false);
            }
            return connector;
        }
    }

    private static class Jetty8ConnectorFactory
    implements ConnectorFactory {
        private Jetty8ConnectorFactory() {
        }

        @Override
        public AbstractConnector createConnector(Server server, InetSocketAddress address, int acceptors, int selectors) {
            try {
                Class<?> connectorClass = ClassUtils.forName(JettyEmbeddedServletContainerFactory.CONNECTOR_JETTY_8, this.getClass().getClassLoader());
                AbstractConnector connector = (AbstractConnector)connectorClass.newInstance();
                ReflectionUtils.findMethod(connectorClass, "setPort", Integer.TYPE).invoke((Object)connector, address.getPort());
                ReflectionUtils.findMethod(connectorClass, "setHost", String.class).invoke((Object)connector, address.getHostString());
                if (acceptors > 0) {
                    ReflectionUtils.findMethod(connectorClass, "setAcceptors", Integer.TYPE).invoke((Object)connector, acceptors);
                }
                if (selectors > 0) {
                    Object selectorManager = ReflectionUtils.findMethod(connectorClass, "getSelectorManager").invoke((Object)connector, new Object[0]);
                    ReflectionUtils.findMethod(selectorManager.getClass(), "setSelectSets", Integer.TYPE).invoke(selectorManager, selectors);
                }
                return connector;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to configure Jetty 8 connector", ex);
            }
        }
    }

    private static interface ConnectorFactory {
        public AbstractConnector createConnector(Server var1, InetSocketAddress var2, int var3, int var4);
    }

    private static class ServerHeaderHandler
    extends HandlerWrapper {
        private static final String SERVER_HEADER = "server";
        private final String value;

        ServerHeaderHandler(String value) {
            this.value = value;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (!response.getHeaderNames().contains(SERVER_HEADER)) {
                response.setHeader(SERVER_HEADER, this.value);
            }
            super.handle(target, baseRequest, request, response);
        }
    }

    private static class ForwardHeadersCustomizer
    implements JettyServerCustomizer {
        private ForwardHeadersCustomizer() {
        }

        @Override
        public void customize(Server server) {
            ForwardedRequestCustomizer customizer = new ForwardedRequestCustomizer();
            for (Connector connector : server.getConnectors()) {
                for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
                    if (!(connectionFactory instanceof HttpConfiguration.ConnectionFactory)) continue;
                    ((HttpConfiguration.ConnectionFactory)connectionFactory).getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)customizer);
                }
            }
        }
    }

    private static class Jetty93GzipHandlerFactory
    implements GzipHandlerFactory {
        private Jetty93GzipHandlerFactory() {
        }

        @Override
        public HandlerWrapper createGzipHandler(Compression compression) {
            GzipHandler handler = new GzipHandler();
            handler.setMinGzipSize(compression.getMinResponseSize());
            handler.setIncludedMimeTypes(compression.getMimeTypes());
            if (compression.getExcludedUserAgents() != null) {
                handler.setExcludedAgentPatterns(compression.getExcludedUserAgents());
            }
            return handler;
        }
    }

    private static class Jetty92GzipHandlerFactory
    implements GzipHandlerFactory {
        private Jetty92GzipHandlerFactory() {
        }

        @Override
        public HandlerWrapper createGzipHandler(Compression compression) {
            try {
                Class<?> handlerClass = ClassUtils.forName(JettyEmbeddedServletContainerFactory.GZIP_HANDLER_JETTY_9_2, this.getClass().getClassLoader());
                HandlerWrapper gzipHandler = (HandlerWrapper)handlerClass.newInstance();
                ReflectionUtils.findMethod(handlerClass, "setMinGzipSize", Integer.TYPE).invoke((Object)gzipHandler, compression.getMinResponseSize());
                ReflectionUtils.findMethod(handlerClass, "addIncludedMimeTypes", String[].class).invoke((Object)gzipHandler, new Object[]{compression.getMimeTypes()});
                if (compression.getExcludedUserAgents() != null) {
                    ReflectionUtils.findMethod(handlerClass, "setExcluded", Set.class).invoke((Object)gzipHandler, new HashSet<String>(Arrays.asList(compression.getExcludedUserAgents())));
                }
                return gzipHandler;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to configure Jetty 9.2 gzip handler", ex);
            }
        }
    }

    private static class Jetty8GzipHandlerFactory
    implements GzipHandlerFactory {
        private Jetty8GzipHandlerFactory() {
        }

        @Override
        public HandlerWrapper createGzipHandler(Compression compression) {
            try {
                Class<?> handlerClass = ClassUtils.forName(JettyEmbeddedServletContainerFactory.GZIP_HANDLER_JETTY_8, this.getClass().getClassLoader());
                HandlerWrapper handler = (HandlerWrapper)handlerClass.newInstance();
                ReflectionUtils.findMethod(handlerClass, "setMinGzipSize", Integer.TYPE).invoke((Object)handler, compression.getMinResponseSize());
                ReflectionUtils.findMethod(handlerClass, "setMimeTypes", Set.class).invoke((Object)handler, new HashSet<String>(Arrays.asList(compression.getMimeTypes())));
                if (compression.getExcludedUserAgents() != null) {
                    ReflectionUtils.findMethod(handlerClass, "setExcluded", Set.class).invoke((Object)handler, new HashSet<String>(Arrays.asList(compression.getExcludedUserAgents())));
                }
                return handler;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to configure Jetty 8 gzip handler", ex);
            }
        }
    }

    private static interface GzipHandlerFactory {
        public HandlerWrapper createGzipHandler(Compression var1);
    }

    private static class Jetty8SslServerConnectorFactory
    implements SslServerConnectorFactory {
        private Jetty8SslServerConnectorFactory() {
        }

        @Override
        public AbstractConnector createConnector(Server server, SslContextFactory sslContextFactory, InetSocketAddress address) {
            try {
                Class<?> connectorClass = Class.forName("org.eclipse.jetty.server.ssl.SslSocketConnector");
                AbstractConnector connector = (AbstractConnector)connectorClass.getConstructor(SslContextFactory.class).newInstance(sslContextFactory);
                connector.getClass().getMethod("setPort", Integer.TYPE).invoke((Object)connector, address.getPort());
                connector.getClass().getMethod("setHost", String.class).invoke((Object)connector, address.getHostString());
                return connector;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static class Jetty9SslServerConnectorFactory
    implements SslServerConnectorFactory {
        private Jetty9SslServerConnectorFactory() {
        }

        public ServerConnector createConnector(Server server, SslContextFactory sslContextFactory, InetSocketAddress address) {
            HttpConfiguration config = new HttpConfiguration();
            config.setSendServerVersion(false);
            config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            HttpConnectionFactory connectionFactory = new HttpConnectionFactory(config);
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
            ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, connectionFactory});
            serverConnector.setPort(address.getPort());
            serverConnector.setHost(address.getHostString());
            return serverConnector;
        }
    }

    private static interface SslServerConnectorFactory {
        public AbstractConnector createConnector(Server var1, SslContextFactory var2, InetSocketAddress var3);
    }
}

