/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.WebApplicationContextServletContextAwareProcessor;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletContextInitializerBeans;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EmbeddedWebApplicationContext
extends GenericWebApplicationContext {
    private static final Log logger = LogFactory.getLog(EmbeddedWebApplicationContext.class);
    public static final String DISPATCHER_SERVLET_NAME = "dispatcherServlet";
    private volatile EmbeddedServletContainer embeddedServletContainer;
    private ServletConfig servletConfig;
    private String namespace;

    @Override
    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor(new WebApplicationContextServletContextAwareProcessor(this));
        beanFactory.ignoreDependencyInterface(ServletContextAware.class);
    }

    @Override
    public final void refresh() throws BeansException, IllegalStateException {
        try {
            super.refresh();
        }
        catch (RuntimeException ex) {
            this.stopAndReleaseEmbeddedServletContainer();
            throw ex;
        }
    }

    @Override
    protected void onRefresh() {
        super.onRefresh();
        try {
            this.createEmbeddedServletContainer();
        }
        catch (Throwable ex) {
            throw new ApplicationContextException("Unable to start embedded container", ex);
        }
    }

    @Override
    protected void finishRefresh() {
        super.finishRefresh();
        EmbeddedServletContainer localContainer = this.startEmbeddedServletContainer();
        if (localContainer != null) {
            this.publishEvent(new EmbeddedServletContainerInitializedEvent(this, localContainer));
        }
    }

    @Override
    protected void onClose() {
        super.onClose();
        this.stopAndReleaseEmbeddedServletContainer();
    }

    private void createEmbeddedServletContainer() {
        EmbeddedServletContainer localContainer = this.embeddedServletContainer;
        ServletContext localServletContext = this.getServletContext();
        if (localContainer == null && localServletContext == null) {
            EmbeddedServletContainerFactory containerFactory = this.getEmbeddedServletContainerFactory();
            this.embeddedServletContainer = containerFactory.getEmbeddedServletContainer(this.getSelfInitializer());
        } else if (localServletContext != null) {
            try {
                this.getSelfInitializer().onStartup(localServletContext);
            }
            catch (ServletException ex) {
                throw new ApplicationContextException("Cannot initialize servlet context", ex);
            }
        }
        this.initPropertySources();
    }

    protected EmbeddedServletContainerFactory getEmbeddedServletContainerFactory() {
        Object[] beanNames = this.getBeanFactory().getBeanNamesForType(EmbeddedServletContainerFactory.class);
        if (beanNames.length == 0) {
            throw new ApplicationContextException("Unable to start EmbeddedWebApplicationContext due to missing EmbeddedServletContainerFactory bean.");
        }
        if (beanNames.length > 1) {
            throw new ApplicationContextException("Unable to start EmbeddedWebApplicationContext due to multiple EmbeddedServletContainerFactory beans : " + StringUtils.arrayToCommaDelimitedString(beanNames));
        }
        return this.getBeanFactory().getBean(beanNames[0], EmbeddedServletContainerFactory.class);
    }

    private ServletContextInitializer getSelfInitializer() {
        return new ServletContextInitializer(){

            @Override
            public void onStartup(ServletContext servletContext) throws ServletException {
                EmbeddedWebApplicationContext.this.selfInitialize(servletContext);
            }
        };
    }

    private void selfInitialize(ServletContext servletContext) throws ServletException {
        this.prepareEmbeddedWebApplicationContext(servletContext);
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        ExistingWebApplicationScopes existingScopes = new ExistingWebApplicationScopes(beanFactory);
        WebApplicationContextUtils.registerWebApplicationScopes(beanFactory, this.getServletContext());
        existingScopes.restore();
        WebApplicationContextUtils.registerEnvironmentBeans(beanFactory, this.getServletContext());
        for (ServletContextInitializer beans : this.getServletContextInitializerBeans()) {
            beans.onStartup(servletContext);
        }
    }

    protected Collection<ServletContextInitializer> getServletContextInitializerBeans() {
        return new ServletContextInitializerBeans(this.getBeanFactory());
    }

    protected void prepareEmbeddedWebApplicationContext(ServletContext servletContext) {
        Object rootContext = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (rootContext != null) {
            if (rootContext == this) {
                throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ServletContextInitializers!");
            }
            return;
        }
        Log logger2 = LogFactory.getLog(ContextLoader.class);
        servletContext.log("Initializing Spring embedded WebApplicationContext");
        try {
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, this);
            if (logger2.isDebugEnabled()) {
                logger2.debug("Published root WebApplicationContext as ServletContext attribute with name [" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]");
            }
            this.setServletContext(servletContext);
            if (logger2.isInfoEnabled()) {
                long elapsedTime = System.currentTimeMillis() - this.getStartupDate();
                logger2.info("Root WebApplicationContext: initialization completed in " + elapsedTime + " ms");
            }
        }
        catch (RuntimeException ex) {
            logger2.error("Context initialization failed", ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, ex);
            throw ex;
        }
        catch (Error ex) {
            logger2.error("Context initialization failed", ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, ex);
            throw ex;
        }
    }

    private EmbeddedServletContainer startEmbeddedServletContainer() {
        EmbeddedServletContainer localContainer = this.embeddedServletContainer;
        if (localContainer != null) {
            localContainer.start();
        }
        return localContainer;
    }

    private void stopAndReleaseEmbeddedServletContainer() {
        EmbeddedServletContainer localContainer = this.embeddedServletContainer;
        if (localContainer != null) {
            try {
                localContainer.stop();
                this.embeddedServletContainer = null;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    @Override
    protected Resource getResourceByPath(String path) {
        if (this.getServletContext() == null) {
            return new DefaultResourceLoader.ClassPathContextResource(path, this.getClassLoader());
        }
        return new ServletContextResource(this.getServletContext(), path);
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public EmbeddedServletContainer getEmbeddedServletContainer() {
        return this.embeddedServletContainer;
    }

    public static class ExistingWebApplicationScopes {
        private static final Set<String> SCOPES;
        private final ConfigurableListableBeanFactory beanFactory;
        private final Map<String, Scope> scopes = new HashMap<String, Scope>();

        public ExistingWebApplicationScopes(ConfigurableListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
            for (String scopeName : SCOPES) {
                Scope scope = beanFactory.getRegisteredScope(scopeName);
                if (scope == null) continue;
                this.scopes.put(scopeName, scope);
            }
        }

        public void restore() {
            for (Map.Entry<String, Scope> entry : this.scopes.entrySet()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Restoring user defined scope " + entry.getKey());
                }
                this.beanFactory.registerScope(entry.getKey(), entry.getValue());
            }
        }

        static {
            LinkedHashSet<String> scopes = new LinkedHashSet<String>();
            scopes.add("request");
            scopes.add("session");
            scopes.add("globalSession");
            SCOPES = Collections.unmodifiableSet(scopes);
        }
    }
}

