/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.support.ResourceEditorRegistrar;
import org.springframework.boot.bind.DefaultPropertyNamePatternsMatcher;
import org.springframework.boot.bind.PropertyNamePatternsMatcher;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

public class PropertiesConfigurationFactory<T>
implements FactoryBean<T>,
ApplicationContextAware,
MessageSourceAware,
InitializingBean {
    private static final char[] EXACT_DELIMITERS = new char[]{'_', '.', '['};
    private static final char[] TARGET_NAME_DELIMITERS = new char[]{'_', '.'};
    private static final Log logger = LogFactory.getLog(PropertiesConfigurationFactory.class);
    private boolean ignoreUnknownFields = true;
    private boolean ignoreInvalidFields;
    private boolean exceptionIfInvalid = true;
    private PropertySources propertySources;
    private final T target;
    private Validator validator;
    private ApplicationContext applicationContext;
    private MessageSource messageSource;
    private boolean hasBeenBound = false;
    private boolean ignoreNestedProperties = false;
    private String targetName;
    private ConversionService conversionService;
    private boolean resolvePlaceholders = true;

    public PropertiesConfigurationFactory(T target) {
        Assert.notNull(target, "target must not be null");
        this.target = target;
    }

    public PropertiesConfigurationFactory(Class<?> type) {
        Assert.notNull(type, "type must not be null");
        this.target = BeanUtils.instantiate(type);
    }

    public void setIgnoreNestedProperties(boolean ignoreNestedProperties) {
        this.ignoreNestedProperties = ignoreNestedProperties;
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public void setIgnoreInvalidFields(boolean ignoreInvalidFields) {
        this.ignoreInvalidFields = ignoreInvalidFields;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setPropertySources(PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Deprecated
    public void setExceptionIfInvalid(boolean exceptionIfInvalid) {
        this.exceptionIfInvalid = exceptionIfInvalid;
    }

    public void setResolvePlaceholders(boolean resolvePlaceholders) {
        this.resolvePlaceholders = resolvePlaceholders;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.bindPropertiesToTarget();
    }

    @Override
    public Class<?> getObjectType() {
        if (this.target == null) {
            return Object.class;
        }
        return this.target.getClass();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public T getObject() throws Exception {
        if (!this.hasBeenBound) {
            this.bindPropertiesToTarget();
        }
        return this.target;
    }

    public void bindPropertiesToTarget() throws BindException {
        Assert.state(this.propertySources != null, "PropertySources should not be null");
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Property Sources: " + this.propertySources);
            }
            this.hasBeenBound = true;
            this.doBindPropertiesToTarget();
        }
        catch (BindException ex) {
            if (this.exceptionIfInvalid) {
                throw ex;
            }
            logger.error("Failed to load Properties validation bean. Your Properties may be invalid.", ex);
        }
    }

    private void doBindPropertiesToTarget() throws BindException {
        RelaxedDataBinder dataBinder;
        RelaxedDataBinder relaxedDataBinder = dataBinder = this.targetName != null ? new RelaxedDataBinder(this.target, this.targetName) : new RelaxedDataBinder(this.target);
        if (this.validator != null && this.validator.supports(dataBinder.getTarget().getClass())) {
            dataBinder.setValidator(this.validator);
        }
        if (this.conversionService != null) {
            dataBinder.setConversionService(this.conversionService);
        }
        dataBinder.setAutoGrowCollectionLimit(Integer.MAX_VALUE);
        dataBinder.setIgnoreNestedProperties(this.ignoreNestedProperties);
        dataBinder.setIgnoreInvalidFields(this.ignoreInvalidFields);
        dataBinder.setIgnoreUnknownFields(this.ignoreUnknownFields);
        this.customizeBinder(dataBinder);
        if (this.applicationContext != null) {
            ResourceEditorRegistrar resourceEditorRegistrar = new ResourceEditorRegistrar(this.applicationContext, this.applicationContext.getEnvironment());
            resourceEditorRegistrar.registerCustomEditors(dataBinder);
        }
        Iterable<String> relaxedTargetNames = this.getRelaxedTargetNames();
        Set<String> names = this.getNames(relaxedTargetNames);
        PropertyValues propertyValues = this.getPropertySourcesPropertyValues(names, relaxedTargetNames);
        dataBinder.bind(propertyValues);
        if (this.validator != null) {
            dataBinder.validate();
        }
        this.checkForBindingErrors(dataBinder);
    }

    private Iterable<String> getRelaxedTargetNames() {
        return this.target != null && StringUtils.hasLength(this.targetName) ? new RelaxedNames(this.targetName) : null;
    }

    private Set<String> getNames(Iterable<String> prefixes) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (this.target != null) {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = BeanUtils.getPropertyDescriptors(this.target.getClass())) {
                String name = descriptor.getName();
                if (name.equals("class")) continue;
                RelaxedNames relaxedNames = RelaxedNames.forCamelCase(name);
                if (prefixes == null) {
                    for (String relaxedName : relaxedNames) {
                        names.add(relaxedName);
                    }
                    continue;
                }
                for (String prefix : prefixes) {
                    for (String relaxedName : relaxedNames) {
                        names.add(prefix + "." + relaxedName);
                        names.add(prefix + "_" + relaxedName);
                    }
                }
            }
        }
        return names;
    }

    private PropertyValues getPropertySourcesPropertyValues(Set<String> names, Iterable<String> relaxedTargetNames) {
        PropertyNamePatternsMatcher includes = this.getPropertyNamePatternsMatcher(names, relaxedTargetNames);
        return new PropertySourcesPropertyValues(this.propertySources, names, includes, this.resolvePlaceholders);
    }

    private PropertyNamePatternsMatcher getPropertyNamePatternsMatcher(Set<String> names, Iterable<String> relaxedTargetNames) {
        if (this.ignoreUnknownFields && !this.isMapTarget()) {
            return new DefaultPropertyNamePatternsMatcher(EXACT_DELIMITERS, true, names);
        }
        if (relaxedTargetNames != null) {
            HashSet<String> relaxedNames = new HashSet<String>();
            for (String relaxedTargetName : relaxedTargetNames) {
                relaxedNames.add(relaxedTargetName);
            }
            return new DefaultPropertyNamePatternsMatcher(TARGET_NAME_DELIMITERS, true, relaxedNames);
        }
        return PropertyNamePatternsMatcher.ALL;
    }

    private boolean isMapTarget() {
        return this.target != null && Map.class.isAssignableFrom(this.target.getClass());
    }

    private void checkForBindingErrors(RelaxedDataBinder dataBinder) throws BindException {
        BindingResult errors = dataBinder.getBindingResult();
        if (errors.hasErrors()) {
            logger.error("Properties configuration failed validation");
            for (ObjectError error : errors.getAllErrors()) {
                logger.error(this.messageSource != null ? this.messageSource.getMessage(error, Locale.getDefault()) + " (" + error + ")" : error);
            }
            if (this.exceptionIfInvalid) {
                throw new BindException(errors);
            }
        }
    }

    protected void customizeBinder(DataBinder dataBinder) {
    }
}

