/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo.embedded;

import com.mongodb.MongoClient;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.DownloadConfigBuilder;
import de.flapdoodle.embed.mongo.config.ExtractedArtifactStoreBuilder;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.Slf4jLevel;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.io.progress.Slf4jProgressListener;
import de.flapdoodle.embed.process.runtime.Network;
import de.flapdoodle.embed.process.store.ArtifactStoreBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoClientDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.data.mongodb.core.MongoClientFactoryBean;
import org.springframework.util.Assert;

@Configuration
@EnableConfigurationProperties(value={MongoProperties.class, EmbeddedMongoProperties.class})
@AutoConfigureBefore(value={MongoAutoConfiguration.class})
@ConditionalOnClass(value={MongoClient.class, MongodStarter.class})
public class EmbeddedMongoAutoConfiguration {
    private static final byte[] IP4_LOOPBACK_ADDRESS = new byte[]{127, 0, 0, 1};
    private static final byte[] IP6_LOOPBACK_ADDRESS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private final MongoProperties properties;
    private final EmbeddedMongoProperties embeddedProperties;
    private final ApplicationContext context;
    private final IRuntimeConfig runtimeConfig;

    public EmbeddedMongoAutoConfiguration(MongoProperties properties, EmbeddedMongoProperties embeddedProperties, ApplicationContext context, IRuntimeConfig runtimeConfig) {
        this.properties = properties;
        this.embeddedProperties = embeddedProperties;
        this.context = context;
        this.runtimeConfig = runtimeConfig;
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean
    public MongodExecutable embeddedMongoServer(IMongodConfig mongodConfig) throws IOException {
        Integer configuredPort = this.properties.getPort();
        if (configuredPort == null || configuredPort == 0) {
            this.setEmbeddedPort(mongodConfig.net().getPort());
        }
        MongodStarter mongodStarter = this.getMongodStarter(this.runtimeConfig);
        return (MongodExecutable)mongodStarter.prepare((IExecutableProcessConfig)mongodConfig);
    }

    private MongodStarter getMongodStarter(IRuntimeConfig runtimeConfig) {
        if (runtimeConfig == null) {
            return MongodStarter.getDefaultInstance();
        }
        return MongodStarter.getInstance((IRuntimeConfig)runtimeConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public IMongodConfig embeddedMongoConfiguration() throws IOException {
        Integer configuredPort;
        ToStringFriendlyFeatureAwareVersion featureAwareVersion = new ToStringFriendlyFeatureAwareVersion(this.embeddedProperties.getVersion(), this.embeddedProperties.getFeatures());
        MongodConfigBuilder builder = new MongodConfigBuilder().version((IFeatureAwareVersion)featureAwareVersion);
        if (this.embeddedProperties.getStorage() != null) {
            builder.replication(new Storage(this.embeddedProperties.getStorage().getDatabaseDir(), this.embeddedProperties.getStorage().getReplSetName(), this.embeddedProperties.getStorage().getOplogSize() != null ? this.embeddedProperties.getStorage().getOplogSize() : 0));
        }
        if ((configuredPort = this.properties.getPort()) != null && configuredPort > 0) {
            builder.net(new Net(this.getHost().getHostAddress(), configuredPort.intValue(), Network.localhostIsIPv6()));
        } else {
            builder.net(new Net(this.getHost().getHostAddress(), Network.getFreeServerPort((InetAddress)this.getHost()), Network.localhostIsIPv6()));
        }
        return builder.build();
    }

    private InetAddress getHost() throws UnknownHostException {
        if (this.properties.getHost() == null) {
            return InetAddress.getByAddress(Network.localhostIsIPv6() ? IP6_LOOPBACK_ADDRESS : IP4_LOOPBACK_ADDRESS);
        }
        return InetAddress.getByName(this.properties.getHost());
    }

    private void setEmbeddedPort(int port) {
        this.setPortProperty(this.context, port);
    }

    private void setPortProperty(ApplicationContext currentContext, int port) {
        if (currentContext instanceof ConfigurableApplicationContext) {
            MutablePropertySources sources = ((ConfigurableApplicationContext)currentContext).getEnvironment().getPropertySources();
            this.getMongoPorts(sources).put("local.mongo.port", port);
        }
        if (currentContext.getParent() != null) {
            this.setPortProperty(currentContext.getParent(), port);
        }
    }

    private Map<String, Object> getMongoPorts(MutablePropertySources sources) {
        MapPropertySource propertySource = sources.get("mongo.ports");
        if (propertySource == null) {
            propertySource = new MapPropertySource("mongo.ports", (Map<String, Object>)new HashMap<String, Object>());
            sources.addFirst(propertySource);
        }
        return (Map)propertySource.getSource();
    }

    private static final class ToStringFriendlyFeatureAwareVersion
    implements IFeatureAwareVersion {
        private final String version;
        private final Set<Feature> features;

        private ToStringFriendlyFeatureAwareVersion(String version, Set<Feature> features) {
            Assert.notNull(version, "version must not be null");
            this.version = version;
            this.features = features != null ? features : Collections.emptySet();
        }

        public String asInDownloadPath() {
            return this.version;
        }

        public boolean enabled(Feature feature) {
            return this.features.contains(feature);
        }

        public String toString() {
            return this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.features.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ToStringFriendlyFeatureAwareVersion other = (ToStringFriendlyFeatureAwareVersion)obj;
                boolean equals = true;
                equals = equals && this.features.equals(other.features);
                equals = equals && this.version.equals(other.version);
                return equals;
            }
            return super.equals(obj);
        }
    }

    @Configuration
    @ConditionalOnClass(value={MongoClient.class, MongoClientFactoryBean.class})
    protected static class EmbeddedMongoDependencyConfiguration
    extends MongoClientDependsOnBeanFactoryPostProcessor {
        public EmbeddedMongoDependencyConfiguration() {
            super("embeddedMongoServer");
        }
    }

    @Configuration
    @ConditionalOnClass(value={Logger.class})
    @ConditionalOnMissingBean(value={IRuntimeConfig.class})
    static class RuntimeConfigConfiguration {
        RuntimeConfigConfiguration() {
        }

        @Bean
        public IRuntimeConfig embeddedMongoRuntimeConfig() {
            Logger logger2 = LoggerFactory.getLogger(this.getClass().getPackage().getName() + ".EmbeddedMongo");
            ProcessOutput processOutput = new ProcessOutput(Processors.logTo((Logger)logger2, (Slf4jLevel)Slf4jLevel.INFO), Processors.logTo((Logger)logger2, (Slf4jLevel)Slf4jLevel.ERROR), Processors.named((String)"[console>]", (IStreamProcessor)Processors.logTo((Logger)logger2, (Slf4jLevel)Slf4jLevel.DEBUG)));
            return new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoD, logger2).processOutput(processOutput).artifactStore((AbstractBuilder)this.getArtifactStore(logger2)).build();
        }

        private ArtifactStoreBuilder getArtifactStore(Logger logger2) {
            return new ExtractedArtifactStoreBuilder().defaults(Command.MongoD).download(new DownloadConfigBuilder().defaultsForCommand(Command.MongoD).progressListener((IProgressListener)new Slf4jProgressListener(logger2)).build());
        }
    }
}

