/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.resolver;

import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;
import org.hibernate.validator.internal.util.privilegedactions.NewInstance;

public class DefaultTraversableResolver
implements TraversableResolver {
    private static final Log log = LoggerFactory.make();
    private static final String PERSISTENCE_CLASS_NAME = "javax.persistence.Persistence";
    private static final String PERSISTENCE_UTIL_METHOD = "getPersistenceUtil";
    private static final String JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME = "org.hibernate.validator.internal.engine.resolver.JPATraversableResolver";
    private TraversableResolver jpaTraversableResolver;

    public DefaultTraversableResolver() {
        this.detectJPA();
    }

    private void detectJPA() {
        Class persistenceClass;
        try {
            persistenceClass = (Class)this.run(LoadClass.action(PERSISTENCE_CLASS_NAME, this.getClass().getClassLoader()));
        }
        catch (ValidationException e) {
            log.debugf("Cannot find %s on classpath. Assuming non JPA 2 environment. All properties will per default be traversable.", (Object)PERSISTENCE_CLASS_NAME);
            return;
        }
        Method persistenceUtilGetter = this.run(GetMethod.action(persistenceClass, PERSISTENCE_UTIL_METHOD));
        if (persistenceUtilGetter == null) {
            log.debugf("Found %s on classpath, but no method '%s'. Assuming JPA 1 environment. All properties will per default be traversable.", (Object)PERSISTENCE_CLASS_NAME, (Object)PERSISTENCE_UTIL_METHOD);
            return;
        }
        try {
            Object persistence = this.run(NewInstance.action(persistenceClass, "persistence provider"));
            ReflectionHelper.getValue(persistenceUtilGetter, persistence);
        }
        catch (Exception e) {
            log.debugf("Unable to invoke %s.%s. Inconsistent JPA environment. All properties will per default be traversable.", (Object)PERSISTENCE_CLASS_NAME, (Object)PERSISTENCE_UTIL_METHOD);
            return;
        }
        log.debugf("Found %s on classpath containing '%s'. Assuming JPA 2 environment. Trying to instantiate JPA aware TraversableResolver", (Object)PERSISTENCE_CLASS_NAME, (Object)PERSISTENCE_UTIL_METHOD);
        try {
            Class jpaAwareResolverClass = (Class)this.run(LoadClass.action(JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME, this.getClass().getClassLoader()));
            this.jpaTraversableResolver = (TraversableResolver)this.run(NewInstance.action(jpaAwareResolverClass, ""));
            log.debugf("Instantiated JPA aware TraversableResolver of type %s.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
        }
        catch (ValidationException e) {
            log.debugf("Unable to load or instantiate JPA aware resolver %s. All properties will per default be traversable.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
        }
    }

    @Override
    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTraversableResolver == null || this.jpaTraversableResolver.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    @Override
    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTraversableResolver == null || this.jpaTraversableResolver.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

