/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.BootstrapConfiguration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.internal.cfg.context.DefaultConstraintMapping;
import org.hibernate.validator.internal.engine.DefaultParameterNameProvider;
import org.hibernate.validator.internal.engine.MethodValidationConfiguration;
import org.hibernate.validator.internal.engine.ServiceLoaderBasedConstraintMappingContributor;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorFactoryImpl;
import org.hibernate.validator.internal.engine.resolver.DefaultTraversableResolver;
import org.hibernate.validator.internal.engine.valuehandling.OptionalValueUnwrapper;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.Version;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;
import org.hibernate.validator.internal.util.privilegedactions.SetContextClassLoader;
import org.hibernate.validator.internal.xml.ValidationBootstrapParameters;
import org.hibernate.validator.internal.xml.ValidationXmlParser;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.spi.cfg.ConstraintMappingContributor;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.hibernate.validator.spi.time.TimeProvider;
import org.hibernate.validator.spi.valuehandling.ValidatedValueUnwrapper;

public class ConfigurationImpl
implements HibernateValidatorConfiguration,
ConfigurationState {
    private static final String JFX_UNWRAPPER_CLASS = "org.hibernate.validator.internal.engine.valuehandling.JavaFXPropertyValueUnwrapper";
    private static final Log log;
    private final ResourceBundleLocator defaultResourceBundleLocator;
    private MessageInterpolator defaultMessageInterpolator;
    private MessageInterpolator messageInterpolator;
    private final TraversableResolver defaultTraversableResolver;
    private final ConstraintValidatorFactory defaultConstraintValidatorFactory;
    private final ParameterNameProvider defaultParameterNameProvider;
    private final ConstraintMappingContributor serviceLoaderBasedConstraintMappingContributor;
    private ValidationProviderResolver providerResolver;
    private final ValidationBootstrapParameters validationBootstrapParameters;
    private boolean ignoreXmlConfiguration = false;
    private final Set<InputStream> configurationStreams = CollectionHelper.newHashSet();
    private BootstrapConfiguration bootstrapConfiguration;
    private final Set<DefaultConstraintMapping> programmaticMappings = CollectionHelper.newHashSet();
    private boolean failFast;
    private final List<ValidatedValueUnwrapper<?>> validatedValueHandlers = CollectionHelper.newArrayList();
    private ClassLoader externalClassLoader;
    private TimeProvider timeProvider;
    private final MethodValidationConfiguration methodValidationConfiguration = new MethodValidationConfiguration();

    public ConfigurationImpl(BootstrapState state) {
        this();
        this.providerResolver = state.getValidationProviderResolver() == null ? state.getDefaultValidationProviderResolver() : state.getValidationProviderResolver();
    }

    public ConfigurationImpl(ValidationProvider<?> provider) {
        this();
        if (provider == null) {
            throw log.getInconsistentConfigurationException();
        }
        this.providerResolver = null;
        this.validationBootstrapParameters.setProvider(provider);
    }

    private ConfigurationImpl() {
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
        TypeResolutionHelper typeResolutionHelper = new TypeResolutionHelper();
        if (this.isJavaFxInClasspath()) {
            this.validatedValueHandlers.add(this.createJavaFXUnwrapperClass(typeResolutionHelper));
        }
        if (Version.getJavaRelease() >= 8) {
            this.validatedValueHandlers.add(new OptionalValueUnwrapper(typeResolutionHelper));
        }
        this.defaultResourceBundleLocator = new PlatformResourceBundleLocator("ValidationMessages");
        this.defaultTraversableResolver = new DefaultTraversableResolver();
        this.defaultConstraintValidatorFactory = new ConstraintValidatorFactoryImpl();
        this.defaultParameterNameProvider = new DefaultParameterNameProvider();
        this.serviceLoaderBasedConstraintMappingContributor = new ServiceLoaderBasedConstraintMappingContributor(typeResolutionHelper);
    }

    private ValidatedValueUnwrapper<?> createJavaFXUnwrapperClass(TypeResolutionHelper typeResolutionHelper) {
        try {
            Class jfxUnwrapperClass = (Class)ConfigurationImpl.run(LoadClass.action(JFX_UNWRAPPER_CLASS, this.getClass().getClassLoader()));
            return (ValidatedValueUnwrapper)jfxUnwrapperClass.getConstructor(TypeResolutionHelper.class).newInstance(typeResolutionHelper);
        }
        catch (Exception e) {
            throw log.validatedValueUnwrapperCannotBeCreated(JFX_UNWRAPPER_CLASS, e);
        }
    }

    @Override
    public final HibernateValidatorConfiguration ignoreXmlConfiguration() {
        this.ignoreXmlConfiguration = true;
        return this;
    }

    @Override
    public final ConfigurationImpl messageInterpolator(MessageInterpolator interpolator) {
        if (log.isDebugEnabled() && interpolator != null) {
            log.debug("Setting custom MessageInterpolator of type " + interpolator.getClass().getName());
        }
        this.validationBootstrapParameters.setMessageInterpolator(interpolator);
        return this;
    }

    @Override
    public final ConfigurationImpl traversableResolver(TraversableResolver resolver) {
        if (log.isDebugEnabled() && resolver != null) {
            log.debug("Setting custom TraversableResolver of type " + resolver.getClass().getName());
        }
        this.validationBootstrapParameters.setTraversableResolver(resolver);
        return this;
    }

    @Override
    public final ConfigurationImpl constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        if (log.isDebugEnabled() && constraintValidatorFactory != null) {
            log.debug("Setting custom ConstraintValidatorFactory of type " + constraintValidatorFactory.getClass().getName());
        }
        this.validationBootstrapParameters.setConstraintValidatorFactory(constraintValidatorFactory);
        return this;
    }

    @Override
    public HibernateValidatorConfiguration parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        if (log.isDebugEnabled() && parameterNameProvider != null) {
            log.debug("Setting custom ParameterNameProvider of type " + parameterNameProvider.getClass().getName());
        }
        this.validationBootstrapParameters.setParameterNameProvider(parameterNameProvider);
        return this;
    }

    @Override
    public final HibernateValidatorConfiguration addMapping(InputStream stream) {
        Contracts.assertNotNull(stream, Messages.MESSAGES.inputStreamCannotBeNull());
        this.validationBootstrapParameters.addMapping(stream.markSupported() ? stream : new BufferedInputStream(stream));
        return this;
    }

    @Override
    public final HibernateValidatorConfiguration failFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public HibernateValidatorConfiguration allowOverridingMethodAlterParameterConstraint(boolean allow) {
        this.methodValidationConfiguration.allowOverridingMethodAlterParameterConstraint(allow);
        return this;
    }

    public boolean isAllowOverridingMethodAlterParameterConstraint() {
        return this.methodValidationConfiguration.isAllowOverridingMethodAlterParameterConstraint();
    }

    @Override
    public HibernateValidatorConfiguration allowMultipleCascadedValidationOnReturnValues(boolean allow) {
        this.methodValidationConfiguration.allowMultipleCascadedValidationOnReturnValues(allow);
        return this;
    }

    public boolean isAllowMultipleCascadedValidationOnReturnValues() {
        return this.methodValidationConfiguration.isAllowMultipleCascadedValidationOnReturnValues();
    }

    @Override
    public HibernateValidatorConfiguration allowParallelMethodsDefineParameterConstraints(boolean allow) {
        this.methodValidationConfiguration.allowParallelMethodsDefineParameterConstraints(allow);
        return this;
    }

    public boolean isAllowParallelMethodsDefineParameterConstraints() {
        return this.methodValidationConfiguration.isAllowParallelMethodsDefineParameterConstraints();
    }

    public MethodValidationConfiguration getMethodValidationConfiguration() {
        return this.methodValidationConfiguration;
    }

    @Override
    public final DefaultConstraintMapping createConstraintMapping() {
        return new DefaultConstraintMapping();
    }

    @Override
    public final HibernateValidatorConfiguration addMapping(ConstraintMapping mapping) {
        Contracts.assertNotNull(mapping, Messages.MESSAGES.parameterMustNotBeNull("mapping"));
        this.programmaticMappings.add((DefaultConstraintMapping)mapping);
        return this;
    }

    @Override
    public final HibernateValidatorConfiguration addProperty(String name, String value) {
        if (value != null) {
            this.validationBootstrapParameters.addConfigProperty(name, value);
        }
        return this;
    }

    @Override
    public HibernateValidatorConfiguration addValidatedValueHandler(ValidatedValueUnwrapper<?> handler) {
        Contracts.assertNotNull(handler, Messages.MESSAGES.parameterMustNotBeNull("handler"));
        this.validatedValueHandlers.add(handler);
        return this;
    }

    public final ConstraintMappingContributor getServiceLoaderBasedConstraintMappingContributor() {
        return this.serviceLoaderBasedConstraintMappingContributor;
    }

    @Override
    public HibernateValidatorConfiguration externalClassLoader(ClassLoader externalClassLoader) {
        Contracts.assertNotNull(externalClassLoader, Messages.MESSAGES.parameterMustNotBeNull("externalClassLoader"));
        this.externalClassLoader = externalClassLoader;
        return this;
    }

    @Override
    public HibernateValidatorConfiguration timeProvider(TimeProvider timeProvider) {
        Contracts.assertNotNull(timeProvider, Messages.MESSAGES.parameterMustNotBeNull("timeProvider"));
        this.timeProvider = timeProvider;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ValidatorFactory buildValidatorFactory() {
        this.parseValidationXml();
        ValidatorFactory factory = null;
        try {
            if (this.isSpecificProvider()) {
                factory = this.validationBootstrapParameters.getProvider().buildValidatorFactory(this);
            } else {
                Class<ValidationProvider<?>> providerClass = this.validationBootstrapParameters.getProviderClass();
                if (providerClass != null) {
                    for (ValidationProvider<?> provider : this.providerResolver.getValidationProviders()) {
                        if (!providerClass.isAssignableFrom(provider.getClass())) continue;
                        factory = provider.buildValidatorFactory(this);
                        break;
                    }
                    if (factory == null) {
                        throw log.getUnableToFindProviderException(providerClass);
                    }
                } else {
                    List<ValidationProvider<?>> providers = this.providerResolver.getValidationProviders();
                    assert (providers.size() != 0);
                    factory = providers.get(0).buildValidatorFactory(this);
                }
            }
        }
        finally {
            for (InputStream in : this.configurationStreams) {
                try {
                    in.close();
                }
                catch (IOException io) {
                    log.unableToCloseInputStream();
                }
            }
        }
        return factory;
    }

    @Override
    public final boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    @Override
    public final MessageInterpolator getMessageInterpolator() {
        if (this.messageInterpolator == null) {
            MessageInterpolator interpolator = this.validationBootstrapParameters.getMessageInterpolator();
            this.messageInterpolator = interpolator != null ? interpolator : this.getDefaultMessageInterpolatorConfiguredWithClassLoader();
        }
        return this.messageInterpolator;
    }

    @Override
    public final Set<InputStream> getMappingStreams() {
        return this.validationBootstrapParameters.getMappings();
    }

    public final boolean getFailFast() {
        return this.failFast;
    }

    @Override
    public final ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.validationBootstrapParameters.getConstraintValidatorFactory();
    }

    @Override
    public final TraversableResolver getTraversableResolver() {
        return this.validationBootstrapParameters.getTraversableResolver();
    }

    @Override
    public BootstrapConfiguration getBootstrapConfiguration() {
        if (this.bootstrapConfiguration == null) {
            this.bootstrapConfiguration = new ValidationXmlParser(this.externalClassLoader).parseValidationXml();
        }
        return this.bootstrapConfiguration;
    }

    @Override
    public ParameterNameProvider getParameterNameProvider() {
        return this.validationBootstrapParameters.getParameterNameProvider();
    }

    public List<ValidatedValueUnwrapper<?>> getValidatedValueHandlers() {
        return this.validatedValueHandlers;
    }

    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    @Override
    public final Map<String, String> getProperties() {
        return this.validationBootstrapParameters.getConfigProperties();
    }

    public ClassLoader getExternalClassLoader() {
        return this.externalClassLoader;
    }

    @Override
    public final MessageInterpolator getDefaultMessageInterpolator() {
        if (this.defaultMessageInterpolator == null) {
            this.defaultMessageInterpolator = new ResourceBundleMessageInterpolator(this.defaultResourceBundleLocator);
        }
        return this.defaultMessageInterpolator;
    }

    @Override
    public final TraversableResolver getDefaultTraversableResolver() {
        return this.defaultTraversableResolver;
    }

    @Override
    public final ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
        return this.defaultConstraintValidatorFactory;
    }

    @Override
    public final ResourceBundleLocator getDefaultResourceBundleLocator() {
        return this.defaultResourceBundleLocator;
    }

    @Override
    public ParameterNameProvider getDefaultParameterNameProvider() {
        return this.defaultParameterNameProvider;
    }

    public final Set<DefaultConstraintMapping> getProgrammaticMappings() {
        return this.programmaticMappings;
    }

    private boolean isSpecificProvider() {
        return this.validationBootstrapParameters.getProvider() != null;
    }

    private void parseValidationXml() {
        if (this.ignoreXmlConfiguration) {
            log.ignoringXmlConfiguration();
            if (this.validationBootstrapParameters.getTraversableResolver() == null) {
                this.validationBootstrapParameters.setTraversableResolver(this.defaultTraversableResolver);
            }
            if (this.validationBootstrapParameters.getConstraintValidatorFactory() == null) {
                this.validationBootstrapParameters.setConstraintValidatorFactory(this.defaultConstraintValidatorFactory);
            }
            if (this.validationBootstrapParameters.getParameterNameProvider() == null) {
                this.validationBootstrapParameters.setParameterNameProvider(this.defaultParameterNameProvider);
            }
        } else {
            ValidationBootstrapParameters xmlParameters = new ValidationBootstrapParameters(this.getBootstrapConfiguration(), this.externalClassLoader);
            this.applyXmlSettings(xmlParameters);
        }
    }

    private void applyXmlSettings(ValidationBootstrapParameters xmlParameters) {
        this.validationBootstrapParameters.setProviderClass(xmlParameters.getProviderClass());
        if (this.validationBootstrapParameters.getMessageInterpolator() == null && xmlParameters.getMessageInterpolator() != null) {
            this.validationBootstrapParameters.setMessageInterpolator(xmlParameters.getMessageInterpolator());
        }
        if (this.validationBootstrapParameters.getTraversableResolver() == null) {
            if (xmlParameters.getTraversableResolver() != null) {
                this.validationBootstrapParameters.setTraversableResolver(xmlParameters.getTraversableResolver());
            } else {
                this.validationBootstrapParameters.setTraversableResolver(this.defaultTraversableResolver);
            }
        }
        if (this.validationBootstrapParameters.getConstraintValidatorFactory() == null) {
            if (xmlParameters.getConstraintValidatorFactory() != null) {
                this.validationBootstrapParameters.setConstraintValidatorFactory(xmlParameters.getConstraintValidatorFactory());
            } else {
                this.validationBootstrapParameters.setConstraintValidatorFactory(this.defaultConstraintValidatorFactory);
            }
        }
        if (this.validationBootstrapParameters.getParameterNameProvider() == null) {
            if (xmlParameters.getParameterNameProvider() != null) {
                this.validationBootstrapParameters.setParameterNameProvider(xmlParameters.getParameterNameProvider());
            } else {
                this.validationBootstrapParameters.setParameterNameProvider(this.defaultParameterNameProvider);
            }
        }
        this.validationBootstrapParameters.addAllMappings(xmlParameters.getMappings());
        this.configurationStreams.addAll(xmlParameters.getMappings());
        for (Map.Entry<String, String> entry : xmlParameters.getConfigProperties().entrySet()) {
            if (this.validationBootstrapParameters.getConfigProperties().get(entry.getKey()) != null) continue;
            this.validationBootstrapParameters.addConfigProperty(entry.getKey(), entry.getValue());
        }
    }

    private boolean isJavaFxInClasspath() {
        return this.isClassPresent("javafx.application.Application", false);
    }

    private boolean isClassPresent(String className, boolean fallbackOnTCCL) {
        try {
            ConfigurationImpl.run(LoadClass.action(className, this.getClass().getClassLoader(), fallbackOnTCCL));
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageInterpolator getDefaultMessageInterpolatorConfiguredWithClassLoader() {
        if (this.externalClassLoader != null) {
            PlatformResourceBundleLocator userResourceBundleLocator = new PlatformResourceBundleLocator("ValidationMessages", this.externalClassLoader);
            PlatformResourceBundleLocator contributorResourceBundleLocator = new PlatformResourceBundleLocator("ContributorValidationMessages", this.externalClassLoader, true);
            ClassLoader originalContextClassLoader = ConfigurationImpl.run(GetClassLoader.fromContext());
            try {
                ConfigurationImpl.run(SetContextClassLoader.action(this.externalClassLoader));
                ResourceBundleMessageInterpolator resourceBundleMessageInterpolator = new ResourceBundleMessageInterpolator((ResourceBundleLocator)userResourceBundleLocator, contributorResourceBundleLocator);
                return resourceBundleMessageInterpolator;
            }
            finally {
                ConfigurationImpl.run(SetContextClassLoader.action(originalContextClassLoader));
            }
        }
        return this.getDefaultMessageInterpolator();
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

