/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv.past;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Past;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.hibernate.validator.internal.util.IgnoreJava6Requirement;
import org.hibernate.validator.spi.time.TimeProvider;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

@IgnoreJava6Requirement
public class PastValidatorForReadablePartial
implements ConstraintValidator<Past, ReadablePartial> {
    @Override
    public void initialize(Past constraintAnnotation) {
    }

    @Override
    public boolean isValid(ReadablePartial value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        TimeProvider timeProvider = context.unwrap(HibernateConstraintValidatorContext.class).getTimeProvider();
        long now = timeProvider.getCurrentTime();
        return value.toDateTime((ReadableInstant)new Instant(now)).isBefore(now);
    }
}

