/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.internal.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class GroupSequenceProviderCheck
extends AbstractConstraintCheck {
    private final Types typeUtils;
    private final AnnotationApiHelper annotationApiHelper;
    private final TypeMirror defaultGroupSequenceProviderType;

    public GroupSequenceProviderCheck(AnnotationApiHelper annotationApiHelper, Types typeUtils) {
        this.typeUtils = typeUtils;
        this.annotationApiHelper = annotationApiHelper;
        this.defaultGroupSequenceProviderType = annotationApiHelper.getDeclaredTypeByName("org.hibernate.validator.spi.group.DefaultGroupSequenceProvider");
    }

    @Override
    public Set<ConstraintCheckIssue> checkNonAnnotationType(TypeElement element, AnnotationMirror annotation) {
        HashSet<ConstraintCheckIssue> errors = CollectionHelper.newHashSet();
        errors.addAll(this.checkHostingElement(element, annotation));
        errors.addAll(this.checkAnnotationValue(element, annotation));
        return errors;
    }

    private Set<ConstraintCheckIssue> checkHostingElement(TypeElement element, AnnotationMirror annotation) {
        if (!element.getKind().isClass()) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "GROUP_SEQUENCE_PROVIDER_ANNOTATION_MUST_BE_DEFINED_ON_A_CLASS", new Object[0]));
        }
        if (this.annotationApiHelper.getMirror(element.getAnnotationMirrors(), "javax.validation.GroupSequence") != null) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "GROUP_SEQUENCE_PROVIDER_ANNOTATION_NOT_ALLOWED_ON_CLASS_WITH_GROUP_SEQUENCE_ANNOTATION", new Object[0]));
        }
        return Collections.emptySet();
    }

    private Set<ConstraintCheckIssue> checkAnnotationValue(TypeElement element, AnnotationMirror annotation) {
        HashSet<ConstraintCheckIssue> errors = CollectionHelper.newHashSet();
        AnnotationValue value = this.annotationApiHelper.getAnnotationValue(annotation, "value");
        TypeMirror valueType = (TypeMirror)value.getValue();
        TypeElement valueElement = (TypeElement)this.typeUtils.asElement(valueType);
        if (valueElement.getKind().isInterface() || valueElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            errors.add(ConstraintCheckIssue.error(element, annotation, "GROUP_SEQUENCE_PROVIDER_ANNOTATION_VALUE_MUST_BE_AN_IMPLEMENTATION_CLASS", new Object[0]));
        } else if (!this.hasPublicDefaultConstructor(valueElement)) {
            errors.add(ConstraintCheckIssue.error(element, annotation, "GROUP_SEQUENCE_PROVIDER_ANNOTATION_VALUE_CLASS_MUST_HAVE_DEFAULT_CONSTRUCTOR", valueType));
        }
        TypeMirror genericProviderType = this.retrieveGenericProviderType(valueType);
        if (!this.typeUtils.isSubtype(element.asType(), genericProviderType)) {
            errors.add(ConstraintCheckIssue.error(element, annotation, "GROUP_SEQUENCE_PROVIDER_ANNOTATION_VALUE_DEFINED_PROVIDER_CLASS_WITH_WRONG_TYPE", genericProviderType, element.asType()));
        }
        return errors;
    }

    private boolean hasPublicDefaultConstructor(TypeElement element) {
        return element.accept(new ElementKindVisitor6<Boolean, Void>(Boolean.FALSE){

            @Override
            public Boolean visitTypeAsClass(TypeElement typeElement, Void aVoid) {
                List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
                for (Element element : enclosedElements) {
                    if (!element.accept(this, aVoid).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitExecutableAsConstructor(ExecutableElement constructorElement, Void aVoid) {
                if (constructorElement.getModifiers().contains((Object)Modifier.PUBLIC) && constructorElement.getParameters().isEmpty()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }, null);
    }

    private TypeMirror retrieveGenericProviderType(TypeMirror typeMirror) {
        return typeMirror.accept(new SimpleTypeVisitor6<TypeMirror, Void>(){

            @Override
            public TypeMirror visitDeclared(DeclaredType declaredType, Void aVoid) {
                TypeMirror eraseType = GroupSequenceProviderCheck.this.typeUtils.erasure(declaredType);
                if (GroupSequenceProviderCheck.this.typeUtils.isSameType(eraseType, GroupSequenceProviderCheck.this.defaultGroupSequenceProviderType)) {
                    List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                    if (!typeArguments.isEmpty()) {
                        return typeArguments.get(0);
                    }
                    return null;
                }
                List<? extends TypeMirror> superTypes = GroupSequenceProviderCheck.this.typeUtils.directSupertypes(declaredType);
                for (TypeMirror typeMirror : superTypes) {
                    TypeMirror genericProviderType = typeMirror.accept(this, aVoid);
                    if (genericProviderType == null) continue;
                    return genericProviderType;
                }
                return null;
            }
        }, null);
    }
}

