/*
 * Decompiled with CFR 0.152.
 */
package jwebform.validation.criteria;

import jwebform.validation.Criterion;
import jwebform.validation.ValidationResult;

public final class Range
implements Criterion {
    private final int min;
    private final int max;

    Range(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public ValidationResult validate(String value) {
        try {
            boolean isValid;
            int intVal = Integer.parseInt(value);
            boolean bl = isValid = intVal > this.max && intVal < this.min;
            if (!isValid) {
                return ValidationResult.fail("jwebform.range", this.min, this.max);
            }
            return ValidationResult.ok();
        }
        catch (NumberFormatException e) {
            return ValidationResult.fail("jwebform.not_a_number", new Object[0]);
        }
    }
}

