/*
 * Decompiled with CFR 0.152.
 */
package jwebform.themes.sourcecode.mapper;

import java.util.Optional;
import jwebform.field.CheckBoxType;
import jwebform.field.HiddenType;
import jwebform.field.LabelType;
import jwebform.field.NumberType;
import jwebform.field.PasswordType;
import jwebform.field.RadioType;
import jwebform.field.SelectType;
import jwebform.field.SubmitType;
import jwebform.field.TextAreaType;
import jwebform.field.TextDateType;
import jwebform.field.TextType;
import jwebform.field.UploadType;
import jwebform.field.structure.FieldType;
import jwebform.field.structure.HTMLProducer;
import jwebform.themes.sourcecode.Theme;
import jwebform.themes.sourcecode.mapper.Mapper;
import jwebform.themes.sourcecode.producer.CheckBoxProducer;
import jwebform.themes.sourcecode.producer.HiddenProducer;
import jwebform.themes.sourcecode.producer.LabelProducer;
import jwebform.themes.sourcecode.producer.NumberProducer;
import jwebform.themes.sourcecode.producer.PasswordProducer;
import jwebform.themes.sourcecode.producer.RadioProducer;
import jwebform.themes.sourcecode.producer.SelectProducer;
import jwebform.themes.sourcecode.producer.SubmitProducer;
import jwebform.themes.sourcecode.producer.TextAreaProducer;
import jwebform.themes.sourcecode.producer.TextDateProducer;
import jwebform.themes.sourcecode.producer.TextProducer;
import jwebform.themes.sourcecode.producer.UploadProducer;

public class StandardMapper
implements Mapper {
    private final Theme theme;

    public StandardMapper(Theme theme) {
        this.theme = theme;
    }

    @Override
    public Optional<HTMLProducer> fromElement(FieldType element) {
        if (element instanceof CheckBoxType) {
            return Optional.of(new CheckBoxProducer(this.theme));
        }
        if (element instanceof TextType) {
            return Optional.of(new TextProducer(this.theme));
        }
        if (element instanceof TextDateType) {
            return Optional.of(new TextDateProducer(this.theme, this));
        }
        if (element instanceof SelectType) {
            return Optional.of(new SelectProducer(this.theme));
        }
        if (element instanceof SubmitType) {
            return Optional.of(new SubmitProducer(this.theme));
        }
        if (element instanceof TextAreaType) {
            return Optional.of(new TextAreaProducer(this.theme));
        }
        if (element instanceof NumberType) {
            return Optional.of(new NumberProducer(this.theme));
        }
        if (element instanceof PasswordType) {
            return Optional.of(new PasswordProducer(this.theme));
        }
        if (element instanceof UploadType) {
            return Optional.of(new UploadProducer(this.theme));
        }
        if (element instanceof LabelType) {
            return Optional.of(new LabelProducer(this.theme));
        }
        if (element instanceof HiddenType) {
            return Optional.of(new HiddenProducer(this.theme));
        }
        if (element instanceof RadioType) {
            return Optional.of(new RadioProducer(this.theme));
        }
        return Optional.empty();
    }
}

