/*
 * Decompiled with CFR 0.152.
 */
package jwebform.themes.sourcecode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jwebform.FormModel;
import jwebform.FormResult;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.HTMLProducer;
import jwebform.integration.FormRenderer;
import jwebform.model.ProducerInfos;
import jwebform.processor.FieldResults;
import jwebform.themes.common.StartEndRenderer;
import jwebform.themes.sourcecode.mapper.Mapper;

public class ThemeJavaRenderer
implements FormRenderer {
    public static final String BOOTSTRAP = "bootstrap";
    private final Mapper mapper;

    public ThemeJavaRenderer(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String render(FormResult result, FormModel.Method method, boolean html5Validation) {
        StringBuilder html = new StringBuilder();
        StartEndRenderer startEndRenderer = new StartEndRenderer(result, method.toString(), html5Validation);
        html.append(startEndRenderer.getStart() + "<fieldset>");
        int tabIndex = 1;
        for (Map.Entry<Field, FieldResult> entry : result.getFieldResults()) {
            FieldResult elementResult = entry.getValue();
            Field container = entry.getKey();
            List<ProducerInfos> childs = this.createProducerInfoChilds(elementResult.getChilds(), tabIndex, result.getFormId());
            ProducerInfos pi = new ProducerInfos(result.getFormId(), tabIndex, elementResult, container, childs);
            Optional<HTMLProducer> producerOptional = this.mapper.fromElement(container.fieldType);
            if (producerOptional.isPresent()) {
                html.append(producerOptional.get().getHTML(pi));
            } else {
                html.append(elementResult.getStaticFieldInfo().getHtmlProducer().getHTML(pi));
            }
            tabIndex += elementResult.getStaticFieldInfo().getTabIndexIncrement();
        }
        html.append("\n</fieldset>" + startEndRenderer.getEnd());
        return html.toString();
    }

    private List<ProducerInfos> createProducerInfoChilds(FieldResults childs, int tabIndex, String formId) {
        ArrayList<ProducerInfos> listOfPis = new ArrayList<ProducerInfos>();
        for (Map.Entry<Field, FieldResult> entry : childs) {
            listOfPis.add(new ProducerInfos(formId, tabIndex, entry.getValue(), entry.getKey()));
            ++tabIndex;
        }
        return listOfPis;
    }
}

