/*
 * Decompiled with CFR 0.152.
 */
package jwebform.themes.sourcecode;

import java.util.HashMap;
import java.util.Map;
import jwebform.FormResult;
import jwebform.field.structure.HTMLProducer;
import jwebform.integration.MessageSource;
import jwebform.themes.common.StartEndRenderer;
import jwebform.themes.sourcecode.BootstrapRadioRenderer;
import jwebform.themes.sourcecode.BootstrapRenderer;
import jwebform.themes.sourcecode.ElementRenderer;
import jwebform.themes.sourcecode.RadioRenderer;
import jwebform.themes.sourcecode.Theme;

public class BootstrapTheme
implements Theme {
    public Map<String, HTMLProducer> htmlProducer;
    protected final ElementRenderer renderer;
    protected final RadioRenderer radioRenderer;
    private static BootstrapTheme instance;

    public static BootstrapTheme instance(MessageSource messageSource) {
        if (instance == null) {
            instance = new BootstrapTheme(messageSource);
        }
        return instance;
    }

    public static BootstrapTheme instance() {
        if (instance == null) {
            instance = new BootstrapTheme(k -> k);
        }
        return instance;
    }

    protected BootstrapTheme(ElementRenderer renderer, RadioRenderer radioRenderer) {
        this.renderer = renderer;
        this.radioRenderer = radioRenderer;
        this.htmlProducer = new HashMap<String, HTMLProducer>();
    }

    protected BootstrapTheme(MessageSource messageSource) {
        this(new BootstrapRenderer(messageSource), new BootstrapRadioRenderer());
    }

    @Override
    public Map<String, HTMLProducer> getHtmlProducer() {
        return this.htmlProducer;
    }

    @Override
    public ElementRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public String getStart(FormResult result, String method, boolean html5Validation) {
        StartEndRenderer start = new StartEndRenderer(result, method, html5Validation);
        return start.getStart() + "<fieldset>\n";
    }

    @Override
    public String getEnd() {
        return "</fieldset></form>";
    }

    @Override
    public RadioRenderer getRadioRenderer(Theme theme) {
        return this.radioRenderer;
    }
}

