/*
 * Decompiled with CFR 0.152.
 */
package jwebform.themes.sourcecode;

import com.coverity.security.Escape;
import java.util.Optional;
import jwebform.field.structure.Decoration;
import jwebform.integration.MessageSource;
import jwebform.model.ProducerInfos;
import jwebform.themes.sourcecode.ElementRenderer;
import jwebform.themes.sourcecode.StringUtils;
import jwebform.themes.sourcecode.Wrapper;
import jwebform.validation.ValidationResult;
import jwebform.validation.Validator;
import jwebform.validation.criteria.MaxLength;

public class BootstrapRenderer
implements ElementRenderer {
    private final MessageSource messageSource;

    public BootstrapRenderer(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public String renderInput(String type, ProducerInfos pi, Decoration decoration, String additional) {
        String placeholder = this.generatePlaceholder(decoration);
        String aria = this.renderAriaDescribedBy(pi, decoration);
        String val = this.renderValue(pi.getValue());
        return this.renderInputFree("<input id=\"form-id-" + pi.getName() + "\" class=\"form-control " + this.calculateErrorClass(pi) + "\" tabindex=\"" + pi.getTabIndex() + "\" type=\"" + type + "\" name=\"" + pi.getName() + "\" value" + val + placeholder + aria + this.renderRequired(pi.getValidator()) + this.renderMaxLen(pi.getValidator()) + additional + ">", pi, decoration, ElementRenderer.InputVariant.normal);
    }

    private String renderMaxLen(Validator validator) {
        Optional<MaxLength> maxLen = validator.getMaxLen();
        if (maxLen.isPresent()) {
            return " maxlength=\"" + maxLen.get().getMaxLength() + "\"";
        }
        return "";
    }

    protected String renderRequired(Validator validator) {
        if (validator.isRequired()) {
            return " required";
        }
        return "";
    }

    @Override
    public String renderInputComplex(String tagname, String inBetweenHtml, ProducerInfos pi, Decoration decoration) {
        String placeholder = this.generatePlaceholder(decoration);
        String aria = this.renderAriaDescribedBy(pi, decoration);
        return this.renderInputFree("<" + tagname + " class=\"form-control\" tabindex=\"" + pi.getTabIndex() + "\" name=\"" + pi.getName() + "\"" + placeholder + aria + this.renderRequired(pi.getValidator()) + this.renderMaxLen(pi.getValidator()) + ">" + inBetweenHtml + "</" + tagname + ">", pi, decoration, ElementRenderer.InputVariant.normal);
    }

    @Override
    public String renderInputFree(String free, ProducerInfos pi, Decoration decoration, ElementRenderer.InputVariant variant) {
        String wrapperClass;
        PlaceWhereToRenderLabel placeWhereToRenderLabel = PlaceWhereToRenderLabel.overInput;
        switch (variant) {
            case radio: {
                wrapperClass = "radio";
                placeWhereToRenderLabel = PlaceWhereToRenderLabel.outside;
                break;
            }
            case checkbox: {
                wrapperClass = this.getGroupClass() + " form-check";
                placeWhereToRenderLabel = PlaceWhereToRenderLabel.underInput;
                break;
            }
            default: {
                wrapperClass = this.getGroupClass();
            }
        }
        return this.renderInputFree(free, pi, decoration, wrapperClass, placeWhereToRenderLabel);
    }

    private String renderInputFree(String free, ProducerInfos pi, Decoration decoration, String classNameWrapper, PlaceWhereToRenderLabel placeWhereToRenderLabel) {
        String errorMessage = this.renderErrorMessage(pi);
        String labelStr = this.generateLabel(pi, decoration);
        String helpHTML = this.renderHelpText(pi, decoration);
        StringBuilder buf = new StringBuilder();
        Wrapper wrapAroundCompleteInfo = this.getWrapper(pi, classNameWrapper);
        if (placeWhereToRenderLabel == PlaceWhereToRenderLabel.outside) {
            Wrapper labelWrapper = new Wrapper("<div class=\"" + this.getGroupClass() + "\">", "</div>");
            buf.append(labelWrapper.start).append(labelStr).append(labelWrapper.end).append(free).append(errorMessage).append(helpHTML).append("\n");
        } else if (placeWhereToRenderLabel == PlaceWhereToRenderLabel.overInput) {
            buf.append(wrapAroundCompleteInfo.start).append(labelStr).append(free).append(errorMessage).append(helpHTML).append(wrapAroundCompleteInfo.end).append("\n");
        } else if (placeWhereToRenderLabel == PlaceWhereToRenderLabel.underInput) {
            buf.append(wrapAroundCompleteInfo.start).append(free).append(errorMessage).append(labelStr).append(helpHTML).append(wrapAroundCompleteInfo.end).append("\n");
        }
        String input = buf.toString();
        return input;
    }

    protected String getGroupClass() {
        return "form-group";
    }

    private Wrapper getWrapper(ProducerInfos pi, String className) {
        return new Wrapper("<div class=\"" + className + "\">", "</div>");
    }

    @Override
    public String calculateErrorClass(ProducerInfos pi) {
        ValidationResult vr = pi.getValidationResult();
        String errorClass = "";
        if (vr.isSuccess()) {
            errorClass = "is-valid";
        } else if (vr.isError()) {
            errorClass = "is-invalid";
        }
        return errorClass;
    }

    protected String generateLabel(ProducerInfos pi, Decoration decoration) {
        StringBuilder labelAppend = new StringBuilder();
        if (pi.getValidator().isRequired()) {
            labelAppend.append(" *");
        }
        StringBuilder complete = new StringBuilder();
        return complete.append("<label class=\"control-label\" for=\"").append(pi.getFormId() + "-" + pi.getName()).append("\">").append(this.messageSource.getMessage(decoration.getLabel())).append((CharSequence)labelAppend).append("</label>").toString();
    }

    protected String generatePlaceholder(Decoration decoration) {
        String placeholder = "";
        if (!decoration.getPlaceholder().isEmpty()) {
            placeholder = " placeholder=\"" + this.messageSource.getMessage(decoration.getPlaceholder()) + "\"";
        }
        return placeholder;
    }

    protected boolean isHelpDesired(Decoration decoration) {
        return !decoration.getHelptext().isEmpty();
    }

    protected String renderHelpText(ProducerInfos pi, Decoration decoration) {
        String helpHTML = this.isHelpDesired(decoration) ? "\n<small id=\"" + pi.getFormId() + "-" + pi.getName() + "-help_block\" class=\"form-text text-muted\">\n" + this.messageSource.getMessage(decoration.getHelptext()) + "\n</small>\n" : "";
        return helpHTML;
    }

    @Override
    public String renderAriaDescribedBy(ProducerInfos pi, Decoration decoration) {
        String aria = this.isHelpDesired(decoration) ? " aria-describedby=\"helpBlock-" + pi.getName() + "\"" : "";
        return aria;
    }

    @Override
    public String renderValue(String val) {
        if (val.length() > 0) {
            val = "=\"" + Escape.html(val) + "\"";
        }
        return val;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Override
    public String renderErrorMessage(ProducerInfos pi) {
        ValidationResult vr = pi.getValidationResult();
        String errorMessage = "";
        if (vr.isError()) {
            errorMessage = StringUtils.isEmpty(vr.getMessageKey()) ? vr.getTranslatedMessage() : this.messageSource.getMessage(vr.getMessageKey());
            return "<div class=\"invalid-feedback\">" + errorMessage + "</div>";
        }
        return "";
    }

    @Override
    public String renderSimpleLabel(String forAttribute, String label) {
        return "<label class=\"control-label\" for=\"" + forAttribute + "\">" + label + "</label>\n";
    }

    static enum PlaceWhereToRenderLabel {
        outside,
        overInput,
        underInput;

    }
}

