/*
 * Decompiled with CFR 0.152.
 */
package jwebform.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jwebform.field.NumberType;
import jwebform.field.PasswordType;
import jwebform.field.RadioType;
import jwebform.field.SelectType;
import jwebform.field.TextType;
import jwebform.field.structure.Decoration;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.FieldType;
import jwebform.validation.ValidationResult;
import jwebform.validation.Validator;

public class ProducerInfos {
    private final String formId;
    private final int tabIndex;
    private final Field field;
    private final FieldResult fieldResult;
    private final List<ProducerInfos> childs;
    private static final List<ProducerInfos> NO_CHILDS = new ArrayList<ProducerInfos>();

    public ProducerInfos(String formId, int tabIndex, FieldResult fieldResult, Field field, List<ProducerInfos> childs) {
        this.formId = formId;
        this.tabIndex = tabIndex;
        this.field = field;
        this.childs = childs;
        this.fieldResult = fieldResult;
    }

    public ProducerInfos(String formId, int tabIndex, FieldResult fieldResult, Field field) {
        this(formId, tabIndex, fieldResult, field, NO_CHILDS);
    }

    public List<ProducerInfos> getChilds() {
        return this.childs;
    }

    public ProducerInfos getTabIndexIncreased() {
        return new ProducerInfos(this.formId, this.tabIndex + 1, this.fieldResult, this.field, this.childs);
    }

    public String getHtml() {
        return this.fieldResult.getStaticFieldInfo().getHtmlProducer().getHTML(this);
    }

    public String getFormId() {
        return this.formId;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public FieldType getType() {
        return this.field.fieldType;
    }

    public String getName() {
        return this.fieldResult.getStaticFieldInfo().getName();
    }

    public String getTypeName() {
        return this.field.fieldType.getClass().getName();
    }

    public Decoration getDecoration() {
        return this.field.decoration;
    }

    public String getValue() {
        return this.fieldResult.getValue();
    }

    public Object getValueObject() {
        return this.fieldResult.getValueObject();
    }

    public Validator getValidator() {
        return new Validator(this.field.criteria);
    }

    public ValidationResult getValidationResult() {
        return this.fieldResult.getValidationResult();
    }

    public FieldResult getFieldResult() {
        return this.fieldResult;
    }

    public Map<String, Object> getFieldInfoMap() {
        HashMap<String, Object> fieldNameInfo = new HashMap<String, Object>();
        fieldNameInfo.put(this.getTypeName(this.field.fieldType), Boolean.TRUE);
        if (this.field.fieldType instanceof TextType) {
            fieldNameInfo.put("type", "text");
        } else if (this.field.fieldType instanceof NumberType) {
            fieldNameInfo.put("type", "number");
        } else if (this.field.fieldType instanceof PasswordType) {
            fieldNameInfo.put("type", "password");
        }
        if (this.field.fieldType instanceof SelectType) {
            SelectType select = (SelectType)this.field.fieldType;
            fieldNameInfo.put("selected", select.getSelectListWithSelected(this.fieldResult.getValue()));
        }
        if (this.field.fieldType instanceof RadioType) {
            RadioType radio = (RadioType)this.field.fieldType;
            fieldNameInfo.put("radioFields", radio.getEntryListWithSelected(this.fieldResult.getValue()));
        }
        return fieldNameInfo;
    }

    private String getTypeName(FieldType fieldType) {
        return fieldType.getClass().getName().replaceAll("jwebform\\.fieldType\\.", "");
    }
}

