/*
 * Decompiled with CFR 0.152.
 */
package jwebform.integration;

import java.util.function.BiConsumer;
import jwebform.FormResult;
import jwebform.env.Env;
import jwebform.env.EnvBuilder;
import jwebform.env.Request;
import jwebform.env.SessionGet;
import jwebform.env.SessionSet;
import jwebform.integration.AjaxResult;
import jwebform.integration.AjaxResultProcessor;
import jwebform.integration.FormRunnerConfig;
import jwebform.integration.InternalFormRunner;

public class ContainerFormRunner<T> {
    private final Env env;
    private final BiConsumer<String, Object> model;
    private final FormResult formResult;
    private final T bean;
    private final InternalFormRunner formRunner = new InternalFormRunner();
    private final FormRunnerConfig formRunnerConfig;

    public ContainerFormRunner(Class<T> typeOfBean, Request request, SessionGet sessionGet, SessionSet sessionSet, BiConsumer<String, Object> model, FormRunnerConfig formRunnerConfig) {
        this.env = new EnvBuilder().of(request, sessionGet, sessionSet);
        this.model = model;
        try {
            this.bean = typeOfBean.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Problem with instanciating the bean of class " + typeOfBean);
        }
        this.formRunnerConfig = formRunnerConfig;
        this.formResult = this.run(this.bean);
    }

    public AjaxResult getAjaxResult() {
        return this.formResult.process(new AjaxResultProcessor());
    }

    private FormResult run(T input) {
        return this.formRunner.run(input, this.env, this.model, this.formRunnerConfig);
    }

    public boolean isValid() {
        return this.formResult.isValid();
    }

    public boolean isSubmitted() {
        return this.formResult.isSubmitted();
    }

    public String getStringValue(String name) {
        return this.formResult.getStringValue(name);
    }

    public T getBean() {
        return this.bean;
    }
}

