/*
 * Decompiled with CFR 0.152.
 */
package jwebform.field.helper;

import java.util.function.Predicate;
import jwebform.env.Env;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.HTMLProducer;
import jwebform.field.structure.StaticFieldInfo;
import jwebform.validation.ValidationResult;
import jwebform.validation.Validator;

public class OneValueTypeProcessor {
    public final String name;
    public final String initialValue;
    private static final Predicate<String> alwaysFine = t -> true;

    public OneValueTypeProcessor(String name, String initialValue) {
        this.name = name;
        this.initialValue = initialValue;
    }

    public FieldResult calculateTypeWithInputCheck(Env.EnvWithSubmitInfo env, HTMLProducer htmlProducer, Predicate<String> validateInput) {
        return this.calculateTypeWithInputCheck(env, htmlProducer, validateInput, 1);
    }

    public FieldResult calculateTypeWithInputCheck(Env.EnvWithSubmitInfo env, HTMLProducer htmlProducer, Predicate<String> validateInput, int tabIndexIncr) {
        String requestVal = env.getEnv().getParameter(this.name);
        String value = "";
        String input = this.fetchValue(env, requestVal, this.initialValue);
        if (validateInput.test(input)) {
            value = input;
        }
        return FieldResult.builder().withValue(value).withStaticFieldInfo(new StaticFieldInfo(this.name, htmlProducer, tabIndexIncr)).build();
    }

    public FieldResult calculateFieldResult(Env.EnvWithSubmitInfo env, HTMLProducer htmlProducer) {
        return this.calculateTypeWithInputCheck(env, htmlProducer, alwaysFine);
    }

    public FieldResult calculateFieldResultNoTabIndexIncrement(Env.EnvWithSubmitInfo env, HTMLProducer htmlProducer) {
        return this.calculateTypeWithInputCheck(env, htmlProducer, alwaysFine, 0);
    }

    public ValidationResult validate(Env.EnvWithSubmitInfo env, Validator validator, String value) {
        if (env.isSubmitted()) {
            return validator.validate(value);
        }
        return ValidationResult.undefined();
    }

    private String fetchValue(Env.EnvWithSubmitInfo env, String requestVal, String initialValue) {
        if (env.isSubmitted()) {
            return requestVal;
        }
        return initialValue;
    }
}

