/*
 * Decompiled with CFR 0.152.
 */
package jwebform.field;

import java.util.Optional;
import jwebform.env.Env;
import jwebform.field.helper.OneValueTypeProcessor;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.SingleFieldType;
import jwebform.field.structure.StaticFieldInfo;
import jwebform.validation.ValidationResult;

public class NumberType
implements SingleFieldType {
    private final int initialNumber;
    public final OneValueTypeProcessor oneValueType;

    public NumberType(String name, int initialValue) {
        this.oneValueType = new OneValueTypeProcessor(name, Integer.toString(initialValue));
        this.initialNumber = initialValue;
    }

    @Override
    public FieldResult apply(Env.EnvWithSubmitInfo env) {
        Optional<Object> numbOptional;
        String requestVal = env.getEnv().getParameter(this.oneValueType.name);
        ValidationResult vr = ValidationResult.undefined();
        int parsedNumber = 0;
        String parsedNumberVal = "";
        if (!env.isSubmitted()) {
            parsedNumber = this.initialNumber;
            numbOptional = Optional.of(this.initialNumber);
            parsedNumberVal = Integer.toString(parsedNumber);
        } else if ("".equals(requestVal)) {
            numbOptional = Optional.empty();
        } else {
            String val = env.isSubmitted() ? requestVal : Integer.toString(this.initialNumber);
            try {
                parsedNumber = Integer.parseInt(val);
                parsedNumberVal = Integer.toString(parsedNumber);
                numbOptional = Optional.of(parsedNumber);
            }
            catch (NumberFormatException e) {
                vr = ValidationResult.fail("jwebform.not_a_number", new Object[0]);
                numbOptional = Optional.empty();
            }
        }
        return FieldResult.builder().withValue(parsedNumberVal).withStaticFieldInfo(new StaticFieldInfo(this.oneValueType.name, t -> "<!-- number -->", 1)).withValidationResult(vr).withValueObject(numbOptional).build();
    }

    public String toString() {
        return String.format("NumberInput. name=%s", this.oneValueType.name);
    }
}

