/*
 * Decompiled with CFR 0.152.
 */
package jwebform.field;

import jwebform.env.Env;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.SingleFieldType;
import jwebform.field.structure.StaticFieldInfo;

public class CheckBoxType
implements SingleFieldType {
    private final String name;
    private final boolean initialValue;

    public CheckBoxType(String name, boolean initialValue) {
        this.name = name;
        this.initialValue = initialValue;
    }

    @Override
    public FieldResult apply(Env.EnvWithSubmitInfo env) {
        boolean checked;
        String requestVal = env.getEnv().getParameter(this.name);
        String value = "true";
        if (!env.isSubmitted()) {
            value = "" + this.initialValue;
            checked = this.initialValue;
        } else {
            checked = true;
            if ("".equals(requestVal) || requestVal == null) {
                value = "";
                checked = false;
            }
        }
        return FieldResult.builder().withValue(value).withStaticFieldInfo(new StaticFieldInfo(this.name, t -> "<!-- checkbox -->", 1)).withValueObject(checked).build();
    }

    public String toString() {
        return String.format("CheckBoxInput. name=%s", this.name);
    }
}

