/*
 * Decompiled with CFR 0.152.
 */
package jwebform.env;

import jwebform.env.Env;
import jwebform.env.Request;
import jwebform.env.SessionGet;
import jwebform.env.SessionSet;

public class EnvBuilder {
    private int maxLen = 50000;
    private Request trimming = String::trim;
    private Request nullCheck = input -> {
        if (input == null) {
            return "";
        }
        return input;
    };
    private Request maxLenCutting = s -> {
        if (s == null) {
            return null;
        }
        if (s.length() < this.maxLen) {
            return s;
        }
        return s.substring(0, this.maxLen);
    };

    public EnvBuilder setMaxLen(int maxLen) {
        this.maxLen = maxLen;
        return this;
    }

    public Env of(Request request) {
        return this.of(request, Env.EMPTY_SESSION_GET, Env.EMPTY_SESSION_SET);
    }

    public Env of(Request request, SessionGet sessionGet, SessionSet sessionSet) {
        return new Env(request.andThen(this.nullCheck).andThen(this.maxLenCutting).andThen(this.trimming), sessionGet, sessionSet);
    }
}

