/*
 * Decompiled with CFR 0.152.
 */
package jwebform;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jwebform.FormResult;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.ForceFileuploadMethod;
import jwebform.model.ProducerInfos;
import jwebform.processor.FieldResults;

public class FormModel {
    private FormResult formResult;
    private final Method method;
    private final Html5Validation html5Validaiton;

    public FormModel(FormResult formResult, Method method, Html5Validation html5Validation) {
        this.formResult = formResult;
        this.method = method;
        this.html5Validaiton = html5Validation;
    }

    public String getFormId() {
        return this.formResult.getFormId();
    }

    public Method getMethodObject() {
        return this.method;
    }

    public String getMethod() {
        return this.method.name();
    }

    public boolean isUploadEnctypeRequired() {
        for (Map.Entry<Field, FieldResult> entry : this.formResult.getFieldResults()) {
            if (!(entry.getKey().fieldType instanceof ForceFileuploadMethod)) continue;
            return true;
        }
        return false;
    }

    public boolean isHtml5Validaiton() {
        return this.html5Validaiton == Html5Validation.ON;
    }

    public ProducerInfosContainer getProducerInfosContainer() {
        ArrayList<ProducerInfos> piList = new ArrayList<ProducerInfos>();
        LinkedHashMap<String, ProducerInfos> piMap = new LinkedHashMap<String, ProducerInfos>();
        ArrayList<String> names = new ArrayList<String>();
        int tabIndex = 1;
        for (Map.Entry<Field, FieldResult> entry : this.formResult.getFieldResults()) {
            FieldResult fieldResult = entry.getValue();
            ProducerInfos pi = new ProducerInfos(this.formResult.getFormId(), tabIndex, fieldResult, entry.getKey(), this.createProducerInfoChilds(fieldResult.getChilds(), tabIndex));
            piList.add(pi);
            piMap.put(fieldResult.getStaticFieldInfo().getName(), pi);
            names.add(fieldResult.getStaticFieldInfo().getName());
            tabIndex += fieldResult.getStaticFieldInfo().getTabIndexIncrement();
        }
        return new ProducerInfosContainer(piMap, piList, names);
    }

    private List<ProducerInfos> createProducerInfoChilds(FieldResults childs, int tabIndex) {
        ArrayList<ProducerInfos> listOfPis = new ArrayList<ProducerInfos>();
        for (Map.Entry<Field, FieldResult> elem : childs) {
            listOfPis.add(new ProducerInfos(this.formResult.getFormId(), tabIndex, elem.getValue(), elem.getKey()));
        }
        return listOfPis;
    }

    public FormResult getFormResult() {
        return this.formResult;
    }

    public Html5Validation getHtml5Validaiton() {
        return this.html5Validaiton;
    }

    public static enum Html5Validation {
        ON,
        OFF;


        public boolean asBoolean() {
            return this == ON;
        }
    }

    public static enum Method {
        POST,
        GET;

    }

    public class ProducerInfosContainer {
        public final Map<String, ProducerInfos> piMap;
        public final List<ProducerInfos> piList;
        public final List<String> names;

        public ProducerInfosContainer(Map<String, ProducerInfos> piMap, List<ProducerInfos> piList, List<String> names) {
            this.piMap = piMap;
            this.piList = piList;
            this.names = names;
        }
    }
}

