/*
 * Decompiled with CFR 0.152.
 */
package jwebform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jwebform.Form;
import jwebform.field.SimpleGroup;
import jwebform.field.builder.FieldBuilder;
import jwebform.field.structure.Field;
import jwebform.field.structure.GroupFieldType;
import jwebform.field.structure.SingleFieldType;
import jwebform.validation.FormValidator;

public class FormBuilder {
    private static final String DEFAULTID = "id";
    private String id = "id";
    private GroupFieldType group = new SimpleGroup(new ArrayList<Field>(), new ArrayList<FormValidator>());
    private List<Field> fields = new ArrayList<Field>();
    private List<FormValidator> formValidators = new ArrayList<FormValidator>();
    private List<FieldBuilder> typeBuilders = new ArrayList<FieldBuilder>();
    private List<SingleFieldType> singleTypes = new ArrayList<SingleFieldType>();

    private FormBuilder(String id) {
        this.id = id;
    }

    public static FormBuilder simple() {
        return new FormBuilder(DEFAULTID);
    }

    public static FormBuilder withId(String id) {
        return new FormBuilder(id);
    }

    public Form build() {
        return new Form(this.id, this.buildGroup());
    }

    private GroupFieldType buildGroup() {
        this.fields.addAll(this.processTypeBuilders());
        this.fields.addAll(this.processSingleTypes());
        this.group.getChilds().addAll(this.fields);
        this.group.getValidators(null).addAll(this.formValidators);
        return this.group;
    }

    private Collection<Field> processSingleTypes() {
        ArrayList<Field> ec = new ArrayList<Field>();
        for (SingleFieldType type : this.singleTypes) {
            ec.add(new Field(type));
        }
        return ec;
    }

    private Collection<Field> processTypeBuilders() {
        ArrayList<Field> elList = new ArrayList<Field>();
        for (FieldBuilder typeBuilder : this.typeBuilders) {
            elList.add(typeBuilder.build());
        }
        return elList;
    }

    public FormBuilder group(GroupFieldType group) {
        this.group = group;
        return this;
    }

    public FormBuilder fields(List<Field> elList) {
        this.fields.addAll(elList);
        return this;
    }

    public FormBuilder fields(Field ... elList) {
        this.fields.addAll(new ArrayList<Field>(Arrays.asList(elList)));
        return this;
    }

    public FormBuilder typeBuilder(List<FieldBuilder> typeBuilders) {
        this.typeBuilders.addAll(typeBuilders);
        return this;
    }

    public FormBuilder typeBuilder(FieldBuilder ... typeBuilder) {
        this.typeBuilders.addAll(new ArrayList<FieldBuilder>(Arrays.asList(typeBuilder)));
        return this;
    }

    public FormBuilder singleTypes(List<SingleFieldType> singleTypeList) {
        this.singleTypes.addAll(singleTypeList);
        return this;
    }

    public FormBuilder singleTypes(SingleFieldType ... singleType) {
        this.singleTypes.addAll(new ArrayList<SingleFieldType>(Arrays.asList(singleType)));
        return this;
    }

    public FormBuilder validation(List<FormValidator> formValidation) {
        this.formValidators.addAll(formValidation);
        return this;
    }

    public FormBuilder validation(FormValidator ... formValidation) {
        this.formValidators.addAll(new ArrayList<FormValidator>(Arrays.asList(formValidation)));
        return this;
    }
}

