/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

class JettyEmbeddedErrorHandler
extends ErrorHandler {
    private static final Set<String> SUPPORTED_METHODS;
    private final ErrorHandler delegate;

    JettyEmbeddedErrorHandler(ErrorHandler delegate) {
        this.delegate = delegate;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.isSupported(request.getMethod())) {
            request = new ErrorHttpServletRequest(request);
        }
        this.delegate.handle(target, baseRequest, request, response);
    }

    private boolean isSupported(String method) {
        for (String supportedMethod : SUPPORTED_METHODS) {
            if (!supportedMethod.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet<String> supportedMethods = new HashSet<String>();
        supportedMethods.add("GET");
        supportedMethods.add("HEAD");
        supportedMethods.add("POST");
        SUPPORTED_METHODS = Collections.unmodifiableSet(supportedMethods);
    }

    private static class ErrorHttpServletRequest
    extends HttpServletRequestWrapper {
        private boolean simulateGetMethod = true;

        ErrorHttpServletRequest(HttpServletRequest request) {
            super(request);
        }

        @Override
        public String getMethod() {
            return this.simulateGetMethod ? HttpMethod.GET.toString() : super.getMethod();
        }

        @Override
        public ServletContext getServletContext() {
            this.simulateGetMethod = false;
            return super.getServletContext();
        }
    }
}

