/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ApplicationHome;
import org.springframework.boot.ApplicationTemp;
import org.springframework.boot.context.embedded.AbstractConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.util.Assert;

public abstract class AbstractEmbeddedServletContainerFactory
extends AbstractConfigurableEmbeddedServletContainer
implements EmbeddedServletContainerFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String[] COMMON_DOC_ROOTS = new String[]{"src/main/webapp", "public", "static"};

    public AbstractEmbeddedServletContainerFactory() {
    }

    public AbstractEmbeddedServletContainerFactory(int port) {
        super(port);
    }

    public AbstractEmbeddedServletContainerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    protected final File getValidDocumentRoot() {
        File file = this.getDocumentRoot();
        file = file != null ? file : this.getWarFileDocumentRoot();
        file = file != null ? file : this.getExplodedWarFileDocumentRoot();
        File file2 = file = file != null ? file : this.getCommonDocumentRoot();
        if (file == null && this.logger.isDebugEnabled()) {
            this.logger.debug("None of the document roots " + Arrays.asList(COMMON_DOC_ROOTS) + " point to a directory and will be ignored.");
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Document root: " + file);
        }
        return file;
    }

    private File getExplodedWarFileDocumentRoot() {
        return this.getExplodedWarFileDocumentRoot(this.getCodeSourceArchive());
    }

    protected List<URL> getUrlsOfJarsWithMetaInfResources() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ArrayList<URL> staticResourceUrls = new ArrayList<URL>();
        if (classLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                if (!this.isStaticResourceJar(url)) continue;
                staticResourceUrls.add(url);
            }
        }
        return staticResourceUrls;
    }

    private boolean isStaticResourceJar(URL url) {
        try {
            if ("file".equals(url.getProtocol())) {
                File file = new File(url.toURI());
                return file.isDirectory() && new File(file, "META-INF/resources").isDirectory() || this.isResourcesJar(file);
            }
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection && this.isResourcesJar((JarURLConnection)connection)) {
                return true;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return false;
    }

    @Deprecated
    protected final String getDecodedFile(URL url) {
        try {
            return URLDecoder.decode(url.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Failed to decode '" + url.getFile() + "' using UTF-8");
        }
    }

    private boolean isResourcesJar(JarURLConnection connection) {
        try {
            return this.isResourcesJar(connection.getJarFile());
        }
        catch (IOException ex) {
            this.logger.warn("Unable to open jar from connection '" + connection + "' to determine if it contains static resources", ex);
            return false;
        }
    }

    private boolean isResourcesJar(File file) {
        try {
            return file.getName().endsWith(".jar") && this.isResourcesJar(new JarFile(file));
        }
        catch (IOException ex) {
            this.logger.warn("Unable to open jar '" + file + "' to determine if it contains static resources", ex);
            return false;
        }
    }

    private boolean isResourcesJar(JarFile jar) throws IOException {
        try {
            boolean bl = jar.getJarEntry("META-INF/resources") != null;
            return bl;
        }
        finally {
            jar.close();
        }
    }

    File getExplodedWarFileDocumentRoot(File codeSourceFile) {
        String path;
        int webInfPathIndex;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Code archive: " + codeSourceFile);
        }
        if (codeSourceFile != null && codeSourceFile.exists() && (webInfPathIndex = (path = codeSourceFile.getAbsolutePath()).indexOf(File.separatorChar + "WEB-INF" + File.separatorChar)) >= 0) {
            path = path.substring(0, webInfPathIndex);
            return new File(path);
        }
        return null;
    }

    private File getWarFileDocumentRoot() {
        return this.getArchiveFileDocumentRoot(".war");
    }

    private File getArchiveFileDocumentRoot(String extension) {
        File file = this.getCodeSourceArchive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Code archive: " + file);
        }
        if (file != null && file.exists() && !file.isDirectory() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(extension)) {
            return file.getAbsoluteFile();
        }
        return null;
    }

    private File getCommonDocumentRoot() {
        for (String commonDocRoot : COMMON_DOC_ROOTS) {
            File root = new File(commonDocRoot);
            if (!root.exists() || !root.isDirectory()) continue;
            return root.getAbsoluteFile();
        }
        return null;
    }

    private File getCodeSourceArchive() {
        return this.getCodeSourceArchive(this.getClass().getProtectionDomain().getCodeSource());
    }

    File getCodeSourceArchive(CodeSource codeSource) {
        try {
            URL location;
            URL uRL = location = codeSource != null ? codeSource.getLocation() : null;
            if (location == null) {
                return null;
            }
            URLConnection connection = location.openConnection();
            String path = connection instanceof JarURLConnection ? ((JarURLConnection)connection).getJarFile().getName() : location.toURI().getPath();
            if (path.contains("!/")) {
                path = path.substring(0, path.indexOf("!/"));
            }
            return new File(path);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected final File getValidSessionStoreDir() {
        return this.getValidSessionStoreDir(true);
    }

    protected final File getValidSessionStoreDir(boolean mkdirs) {
        File dir = this.getSessionStoreDir();
        if (dir == null) {
            return new ApplicationTemp().getDir("servlet-sessions");
        }
        if (!dir.isAbsolute()) {
            dir = new File(new ApplicationHome().getDir(), dir.getPath());
        }
        if (!dir.exists() && mkdirs) {
            dir.mkdirs();
        }
        Assert.state(!mkdirs || dir.exists(), "Session dir " + dir + " does not exist");
        Assert.state(!dir.isFile(), "Session dir " + dir + " points to a file");
        return dir;
    }

    protected File createTempDir(String prefix) {
        try {
            File tempDir = File.createTempFile(prefix + ".", "." + this.getPort());
            tempDir.delete();
            tempDir.mkdir();
            tempDir.deleteOnExit();
            return tempDir;
        }
        catch (IOException ex) {
            throw new EmbeddedServletContainerException("Unable to create tempDir. java.io.tmpdir is set to " + System.getProperty("java.io.tmpdir"), ex);
        }
    }
}

