/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.NodeId;

public class YamlJavaBeanPropertyConstructor
extends Constructor {
    private final Map<Class<?>, Map<String, Property>> properties = new HashMap();
    private final PropertyUtils propertyUtils = new PropertyUtils();

    public YamlJavaBeanPropertyConstructor(Class<?> theRoot) {
        super(theRoot);
        this.yamlClassConstructors.put(NodeId.mapping, new CustomPropertyConstructMapping());
    }

    public YamlJavaBeanPropertyConstructor(Class<?> theRoot, Map<Class<?>, Map<String, String>> propertyAliases) {
        this(theRoot);
        for (Class<?> key : propertyAliases.keySet()) {
            Map<String, String> map = propertyAliases.get(key);
            if (map == null) continue;
            for (String alias : map.keySet()) {
                this.addPropertyAlias(alias, key, map.get(alias));
            }
        }
    }

    protected final void addPropertyAlias(String alias, Class<?> type, String name) {
        Map<String, Property> typeMap = this.properties.get(type);
        if (typeMap == null) {
            typeMap = new HashMap<String, Property>();
            this.properties.put(type, typeMap);
        }
        try {
            typeMap.put(alias, this.propertyUtils.getProperty(type, name));
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException(ex);
        }
    }

    class CustomPropertyConstructMapping
    extends Constructor.ConstructMapping {
        CustomPropertyConstructMapping() {
            super(YamlJavaBeanPropertyConstructor.this);
        }

        protected Property getProperty(Class<?> type, String name) throws IntrospectionException {
            Map forType = (Map)YamlJavaBeanPropertyConstructor.this.properties.get(type);
            Property property = forType != null ? (Property)forType.get(name) : null;
            return property != null ? property : super.getProperty(type, name);
        }
    }
}

