/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AbstractDatabaseInitializer;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class JdbcSessionDatabaseInitializer
extends AbstractDatabaseInitializer {
    private final SessionProperties.Jdbc properties;

    public JdbcSessionDatabaseInitializer(DataSource dataSource, ResourceLoader resourceLoader, SessionProperties properties) {
        super(dataSource, resourceLoader);
        Assert.notNull(properties, "SessionProperties must not be null");
        this.properties = properties.getJdbc();
    }

    @Override
    protected boolean isEnabled() {
        return this.properties.getInitializer().isEnabled();
    }

    @Override
    protected String getSchemaLocation() {
        return this.properties.getSchema();
    }
}

