/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ldap;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@ConfigurationProperties(prefix="spring.ldap")
public class LdapProperties {
    private static final int DEFAULT_PORT = 389;
    private String[] urls;
    private String base;
    private String username;
    private String password;
    private Map<String, String> baseEnvironment = new HashMap<String, String>();

    public String[] getUrls() {
        return this.urls;
    }

    public void setUrls(String[] urls) {
        this.urls = urls;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getBaseEnvironment() {
        return this.baseEnvironment;
    }

    public void setBaseEnvironment(Map<String, String> baseEnvironment) {
        this.baseEnvironment = baseEnvironment;
    }

    public String[] determineUrls(Environment environment) {
        if (ObjectUtils.isEmpty(this.urls)) {
            return new String[]{"ldap://localhost:" + this.determinePort(environment)};
        }
        return this.urls;
    }

    private int determinePort(Environment environment) {
        Assert.notNull(environment, "Environment must not be null");
        String localPort = environment.getProperty("local.ldap.port");
        if (localPort != null) {
            return Integer.valueOf(localPort);
        }
        return 389;
    }
}

