/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;

abstract class DataSourceConfiguration {
    DataSourceConfiguration() {
    }

    protected static <T> T createDataSource(DataSourceProperties properties, Class<? extends javax.sql.DataSource> type) {
        return (T)properties.initializeDataSourceBuilder().type(type).build();
    }

    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"})
    static class Generic {
        Generic() {
        }

        @Bean
        public javax.sql.DataSource dataSource(DataSourceProperties properties) {
            return properties.initializeDataSourceBuilder().build();
        }
    }

    @ConditionalOnClass(value={org.apache.commons.dbcp2.BasicDataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="org.apache.commons.dbcp2.BasicDataSource", matchIfMissing=true)
    static class Dbcp2 {
        Dbcp2() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.dbcp2")
        public org.apache.commons.dbcp2.BasicDataSource dataSource(DataSourceProperties properties) {
            return (org.apache.commons.dbcp2.BasicDataSource)DataSourceConfiguration.createDataSource(properties, org.apache.commons.dbcp2.BasicDataSource.class);
        }
    }

    @ConditionalOnClass(value={BasicDataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="org.apache.commons.dbcp.BasicDataSource", matchIfMissing=true)
    @Deprecated
    static class Dbcp {
        Dbcp() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.dbcp")
        public BasicDataSource dataSource(DataSourceProperties properties) {
            BasicDataSource dataSource = (BasicDataSource)DataSourceConfiguration.createDataSource(properties, BasicDataSource.class);
            DatabaseDriver databaseDriver = DatabaseDriver.fromJdbcUrl(properties.determineUrl());
            String validationQuery = databaseDriver.getValidationQuery();
            if (validationQuery != null) {
                dataSource.setTestOnBorrow(true);
                dataSource.setValidationQuery(validationQuery);
            }
            return dataSource;
        }
    }

    @ConditionalOnClass(value={HikariDataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="com.zaxxer.hikari.HikariDataSource", matchIfMissing=true)
    static class Hikari {
        Hikari() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.hikari")
        public HikariDataSource dataSource(DataSourceProperties properties) {
            return (HikariDataSource)DataSourceConfiguration.createDataSource(properties, HikariDataSource.class);
        }
    }

    @ConditionalOnClass(value={DataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="org.apache.tomcat.jdbc.pool.DataSource", matchIfMissing=true)
    static class Tomcat {
        Tomcat() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.tomcat")
        public DataSource dataSource(DataSourceProperties properties) {
            DataSource dataSource = (DataSource)DataSourceConfiguration.createDataSource(properties, DataSource.class);
            DatabaseDriver databaseDriver = DatabaseDriver.fromJdbcUrl(properties.determineUrl());
            String validationQuery = databaseDriver.getValidationQuery();
            if (validationQuery != null) {
                dataSource.setTestOnBorrow(true);
                dataSource.setValidationQuery(validationQuery);
            }
            return dataSource;
        }
    }
}

