/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.logging.formatter;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.hibernate.validator.internal.util.ExecutableHelper;

public class ExecutableFormatter {
    private final String stringRepresentation;

    public ExecutableFormatter(Executable executable) {
        String name = ExecutableHelper.getSimpleName((Executable)executable);
        if (executable instanceof Method) {
            name = executable.getDeclaringClass().getSimpleName() + "#" + name;
        }
        Class[] parameterTypes = executable.getParameterTypes();
        this.stringRepresentation = ExecutableHelper.getExecutableAsString((String)name, (Class[])parameterTypes);
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

