/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.valueextraction;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.BooleanArrayValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ByteArrayValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.CharArrayValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.DoubleArrayValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.FloatArrayValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.IntArrayValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.IterableValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ListPropertyValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ListValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.LongArrayValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.MapKeyExtractor;
import org.hibernate.validator.internal.engine.valueextraction.MapPropertyKeyExtractor;
import org.hibernate.validator.internal.engine.valueextraction.MapPropertyValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.MapValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ObjectArrayValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ObservableValueValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.OptionalDoubleValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.OptionalIntValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.OptionalLongValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.OptionalValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ReadOnlyListPropertyValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ReadOnlyMapPropertyKeyExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ReadOnlyMapPropertyValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ReadOnlySetPropertyValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.SetPropertyValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ShortArrayValueExtractor;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorHelper;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.TypeVariableBindings;
import org.hibernate.validator.internal.util.TypeVariables;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;

public class ValueExtractorManager {
    private static final Log LOG = LoggerFactory.make();
    public static final Set<ValueExtractorDescriptor> SPEC_DEFINED_EXTRACTORS;
    private final Map<ValueExtractorDescriptor.Key, ValueExtractorDescriptor> valueExtractors;

    public ValueExtractorManager(Set<ValueExtractor<?>> externalExtractors) {
        LinkedHashMap<ValueExtractorDescriptor.Key, ValueExtractorDescriptor> tmpValueExtractors = new LinkedHashMap<ValueExtractorDescriptor.Key, ValueExtractorDescriptor>();
        for (ValueExtractorDescriptor valueExtractorDescriptor : SPEC_DEFINED_EXTRACTORS) {
            tmpValueExtractors.put(valueExtractorDescriptor.getKey(), valueExtractorDescriptor);
        }
        for (ValueExtractor valueExtractor : externalExtractors) {
            ValueExtractorDescriptor descriptor = new ValueExtractorDescriptor(valueExtractor);
            tmpValueExtractors.put(descriptor.getKey(), descriptor);
        }
        this.valueExtractors = Collections.unmodifiableMap(tmpValueExtractors);
    }

    public ValueExtractorManager(ValueExtractorManager template, Map<ValueExtractorDescriptor.Key, ValueExtractorDescriptor> externalValueExtractorDescriptors) {
        LinkedHashMap<ValueExtractorDescriptor.Key, ValueExtractorDescriptor> tmpValueExtractors = new LinkedHashMap<ValueExtractorDescriptor.Key, ValueExtractorDescriptor>(template.valueExtractors);
        tmpValueExtractors.putAll(externalValueExtractorDescriptors);
        this.valueExtractors = Collections.unmodifiableMap(tmpValueExtractors);
    }

    public static Set<ValueExtractor<?>> getDefaultValueExtractors() {
        return SPEC_DEFINED_EXTRACTORS.stream().map(d -> d.getValueExtractor()).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public Set<ValueExtractorDescriptor> getMaximallySpecificValueExtractors(Class<?> valueType) {
        Set<ValueExtractorDescriptor> typeCompatibleExtractors = this.valueExtractors.values().stream().filter(e -> TypeHelper.isAssignable(TypeHelper.getErasedReferenceType(e.getContainerType()), valueType)).collect(Collectors.toSet());
        return this.getMaximallySpecificValueExtractors(valueType, typeCompatibleExtractors);
    }

    public ValueExtractorDescriptor getMaximallySpecificAndContainerElementCompliantValueExtractor(Class<?> declaredType, TypeVariable<?> typeParameter) {
        Set<ValueExtractorDescriptor> maximallySpecificContainerElementCompliantValueExtractors = this.getMaximallySpecificValueExtractors(declaredType, this.getTypeCompliantAndContainerElementCompliantValueExtractors(declaredType, typeParameter));
        if (maximallySpecificContainerElementCompliantValueExtractors.isEmpty()) {
            return null;
        }
        if (maximallySpecificContainerElementCompliantValueExtractors.size() == 1) {
            return maximallySpecificContainerElementCompliantValueExtractors.iterator().next();
        }
        throw LOG.getUnableToGetMostSpecificValueExtractorDueToSeveralMaximallySpecificValueExtractorsDeclaredException(declaredType, ValueExtractorHelper.toValueExtractorClasses(maximallySpecificContainerElementCompliantValueExtractors));
    }

    public ValueExtractorDescriptor getMaximallySpecificAndContainerElementCompliantValueExtractor(Set<ValueExtractorDescriptor> valueExtractorCandidates, Class<?> valueType) {
        Contracts.assertNotEmpty(valueExtractorCandidates, (String)"The value extractor candidate set may not be empty for type: %1$s.", (Object[])new Object[]{valueType});
        Set<ValueExtractorDescriptor> maximallySpecificContainerElementCompliantValueExtractors = this.getMaximallySpecificValueExtractors(valueType, valueExtractorCandidates);
        if (maximallySpecificContainerElementCompliantValueExtractors.isEmpty()) {
            return null;
        }
        if (maximallySpecificContainerElementCompliantValueExtractors.size() == 1) {
            return maximallySpecificContainerElementCompliantValueExtractors.iterator().next();
        }
        throw LOG.getUnableToGetMostSpecificValueExtractorDueToSeveralMaximallySpecificValueExtractorsDeclaredException(valueType, ValueExtractorHelper.toValueExtractorClasses(maximallySpecificContainerElementCompliantValueExtractors));
    }

    public Set<ValueExtractorDescriptor> getValueExtractorCandidatesForCascadedValidation(Type declaredType, TypeVariable<?> typeParameter) {
        HashSet<ValueExtractorDescriptor> valueExtractorDescriptors = new HashSet<ValueExtractorDescriptor>();
        valueExtractorDescriptors.addAll(this.getTypeCompliantAndContainerElementCompliantValueExtractors(declaredType, typeParameter));
        valueExtractorDescriptors.addAll(this.getPotentiallyRuntimeTypeCompliantAndContainerElementCompliantValueExtractors(declaredType, typeParameter));
        return valueExtractorDescriptors;
    }

    private Set<ValueExtractorDescriptor> getTypeCompliantAndContainerElementCompliantValueExtractors(Type declaredType, TypeVariable<?> typeParameter) {
        boolean isInternal = TypeVariables.isInternal(typeParameter);
        Map<Class<?>, Map<TypeVariable<?>, TypeVariable<?>>> allBindings = null;
        if (!isInternal) {
            allBindings = TypeVariableBindings.getTypeVariableBindings((Class)typeParameter.getGenericDeclaration());
        }
        Set typeCompatibleExtractors = this.valueExtractors.values().stream().filter(e -> TypeHelper.isAssignable(e.getContainerType(), declaredType)).collect(Collectors.toSet());
        HashSet<ValueExtractorDescriptor> containerElementCompliantExtractors = new HashSet<ValueExtractorDescriptor>();
        for (ValueExtractorDescriptor extractorDescriptor : typeCompatibleExtractors) {
            TypeVariable<?> typeParameterBoundToExtractorType;
            if (!isInternal) {
                Map<TypeVariable<?>, TypeVariable<?>> bindingsForExtractorType = allBindings.get(extractorDescriptor.getContainerType());
                typeParameterBoundToExtractorType = this.bind(typeParameter, bindingsForExtractorType);
            } else {
                typeParameterBoundToExtractorType = typeParameter;
            }
            if (!Objects.equals(extractorDescriptor.getExtractedTypeParameter(), typeParameterBoundToExtractorType)) continue;
            containerElementCompliantExtractors.add(extractorDescriptor);
        }
        return containerElementCompliantExtractors;
    }

    private Set<ValueExtractorDescriptor> getPotentiallyRuntimeTypeCompliantAndContainerElementCompliantValueExtractors(Type declaredType, TypeVariable<?> typeParameter) {
        boolean isInternal = TypeVariables.isInternal(typeParameter);
        Class<?> erasedDeclaredType = TypeHelper.getErasedReferenceType(declaredType);
        Set typeCompatibleExtractors = this.valueExtractors.values().stream().filter(e -> TypeHelper.isAssignable(erasedDeclaredType, e.getContainerType())).collect(Collectors.toSet());
        HashSet<ValueExtractorDescriptor> containerElementCompliantExtractors = new HashSet<ValueExtractorDescriptor>();
        for (ValueExtractorDescriptor extractorDescriptor : typeCompatibleExtractors) {
            TypeVariable<?> typeParameterBoundToExtractorType;
            if (!isInternal) {
                Map<Class<?>, Map<TypeVariable<?>, TypeVariable<?>>> allBindings = TypeVariableBindings.getTypeVariableBindings(extractorDescriptor.getContainerType());
                Map<TypeVariable<?>, TypeVariable<?>> bindingsForExtractorType = allBindings.get(erasedDeclaredType);
                typeParameterBoundToExtractorType = this.bind(extractorDescriptor.getExtractedTypeParameter(), bindingsForExtractorType);
            } else {
                typeParameterBoundToExtractorType = typeParameter;
            }
            if (!Objects.equals(typeParameter, typeParameterBoundToExtractorType)) continue;
            containerElementCompliantExtractors.add(extractorDescriptor);
        }
        return containerElementCompliantExtractors;
    }

    private Set<ValueExtractorDescriptor> getMaximallySpecificValueExtractors(Class<?> valueType, Set<ValueExtractorDescriptor> extractors) {
        HashSet<ValueExtractorDescriptor> candidates = CollectionHelper.newHashSet(extractors.size());
        for (ValueExtractorDescriptor descriptor : extractors) {
            if (!TypeHelper.isAssignable(descriptor.getContainerType(), valueType)) continue;
            if (candidates.isEmpty()) {
                candidates.add(descriptor);
                continue;
            }
            Iterator candidatesIterator = candidates.iterator();
            boolean isNewRoot = true;
            while (candidatesIterator.hasNext()) {
                ValueExtractorDescriptor candidate = (ValueExtractorDescriptor)candidatesIterator.next();
                if (candidate.getContainerType().equals(descriptor.getContainerType())) continue;
                if (TypeHelper.isAssignable(candidate.getContainerType(), descriptor.getContainerType())) {
                    candidatesIterator.remove();
                    continue;
                }
                if (!TypeHelper.isAssignable(descriptor.getContainerType(), candidate.getContainerType())) continue;
                isNewRoot = false;
            }
            if (!isNewRoot) continue;
            candidates.add(descriptor);
        }
        return candidates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.valueExtractors == null ? 0 : this.valueExtractors.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueExtractorManager other = (ValueExtractorManager)obj;
        return this.valueExtractors.equals(other.valueExtractors);
    }

    private TypeVariable<?> bind(TypeVariable<?> typeParameter, Map<TypeVariable<?>, TypeVariable<?>> bindings) {
        return bindings != null ? bindings.get(typeParameter) : null;
    }

    private static boolean isJavaFxInClasspath() {
        return ValueExtractorManager.isClassPresent("javafx.application.Application", false);
    }

    private static boolean isClassPresent(String className, boolean fallbackOnTCCL) {
        try {
            ValueExtractorManager.run(LoadClass.action(className, ValueExtractorManager.class.getClassLoader(), fallbackOnTCCL));
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    static {
        LinkedHashSet<ValueExtractorDescriptor> specDefinedExtractors = new LinkedHashSet<ValueExtractorDescriptor>();
        if (ValueExtractorManager.isJavaFxInClasspath()) {
            specDefinedExtractors.add(ObservableValueValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(ListPropertyValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(ReadOnlyListPropertyValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(MapPropertyValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(ReadOnlyMapPropertyValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(MapPropertyKeyExtractor.DESCRIPTOR);
            specDefinedExtractors.add(ReadOnlyMapPropertyKeyExtractor.DESCRIPTOR);
            specDefinedExtractors.add(SetPropertyValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(ReadOnlySetPropertyValueExtractor.DESCRIPTOR);
        }
        specDefinedExtractors.add(ByteArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(ShortArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(IntArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(LongArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(FloatArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(DoubleArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(CharArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(BooleanArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(ObjectArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(ListValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(MapValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(MapKeyExtractor.DESCRIPTOR);
        specDefinedExtractors.add(IterableValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(OptionalValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(OptionalIntValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(OptionalDoubleValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(OptionalLongValueExtractor.DESCRIPTOR);
        SPEC_DEFINED_EXTRACTORS = Collections.unmodifiableSet(specDefinedExtractors);
    }
}

